/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs.follow;

import android.os.Handler;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.manager.MavLinkDroneManager;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowAbove;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowCircle;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowGuidedScan;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowLead;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowLeash;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowLeft;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowLookAtMe;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowRight;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowSoloShot;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowSplineAbove;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowSplineLeash;
import org.droidplanner.services.android.impl.core.gcs.location.Location;
import org.droidplanner.services.android.impl.core.gcs.roi.ROIEstimator;

public abstract class FollowAlgorithm {
    protected final MavLinkDroneManager droneMgr;
    private final ROIEstimator roiEstimator;
    private final AtomicBoolean isFollowEnabled = new AtomicBoolean(false);

    public FollowAlgorithm(MavLinkDroneManager droneMgr, Handler handler) {
        this.droneMgr = droneMgr;
        MavLinkDrone drone = (MavLinkDrone)droneMgr.getDrone();
        this.roiEstimator = this.initROIEstimator(drone, handler);
    }

    protected boolean isFollowEnabled() {
        return this.isFollowEnabled.get();
    }

    public void enableFollow() {
        this.isFollowEnabled.set(true);
        if (this.roiEstimator != null) {
            this.roiEstimator.enableFollow();
        }
    }

    public void disableFollow() {
        if (this.isFollowEnabled.compareAndSet(true, false) && this.roiEstimator != null) {
            this.roiEstimator.disableFollow();
        }
    }

    public void updateAlgorithmParams(Map<String, ?> paramsMap) {
    }

    protected ROIEstimator initROIEstimator(MavLinkDrone drone, Handler handler) {
        return new ROIEstimator(drone, handler);
    }

    protected ROIEstimator getROIEstimator() {
        return this.roiEstimator;
    }

    public final void onLocationReceived(Location location) {
        if (this.isFollowEnabled.get()) {
            if (this.roiEstimator != null) {
                this.roiEstimator.onLocationUpdate(location);
            }
            this.processNewLocation(location);
        }
    }

    protected abstract void processNewLocation(Location var1);

    public abstract FollowModes getType();

    public Map<String, Object> getParams() {
        return Collections.emptyMap();
    }

    public static enum FollowModes {
        LEASH("Leash"),
        LEAD("Lead"),
        RIGHT("Right"),
        LEFT("Left"),
        CIRCLE("Orbit"),
        ABOVE("Above"),
        SPLINE_LEASH("Vector Leash"),
        SPLINE_ABOVE("Vector Above"),
        GUIDED_SCAN("Guided Scan"),
        LOOK_AT_ME("Look At Me"),
        SOLO_SHOT("Solo Follow Shot");

        private String name;

        private FollowModes(String str) {
            this.name = str;
        }

        public String toString() {
            return this.name;
        }

        public FollowModes next() {
            return FollowModes.values()[(this.ordinal() + 1) % FollowModes.values().length];
        }

        public FollowAlgorithm getAlgorithmType(MavLinkDroneManager droneMgr, Handler handler) {
            switch (this) {
                default: {
                    return new FollowLeash(droneMgr, handler, 8.0);
                }
                case LEAD: {
                    return new FollowLead(droneMgr, handler, 15.0);
                }
                case RIGHT: {
                    return new FollowRight(droneMgr, handler, 10.0);
                }
                case LEFT: {
                    return new FollowLeft(droneMgr, handler, 10.0);
                }
                case CIRCLE: {
                    return new FollowCircle(droneMgr, handler, 15.0, 10.0);
                }
                case ABOVE: {
                    return new FollowAbove(droneMgr, handler);
                }
                case SPLINE_LEASH: {
                    return new FollowSplineLeash(droneMgr, handler, 8.0);
                }
                case SPLINE_ABOVE: {
                    return new FollowSplineAbove(droneMgr, handler);
                }
                case GUIDED_SCAN: {
                    return new FollowGuidedScan(droneMgr, handler);
                }
                case LOOK_AT_ME: {
                    return new FollowLookAtMe(droneMgr, handler);
                }
                case SOLO_SHOT: 
            }
            return new FollowSoloShot(droneMgr, handler);
        }
    }
}

