/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.variables;

import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneVariable;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;

public class Type
extends DroneVariable<MavLinkDrone>
implements DroneInterfaces.OnDroneListener<MavLinkDrone> {
    private static final int DEFAULT_TYPE = 0;
    private int type = 0;
    private String firmwareVersion = null;

    public Type(MavLinkDrone myDrone) {
        super(myDrone);
        myDrone.addDroneListener(this);
    }

    public void setType(int type) {
        if (this.type != type) {
            this.type = type;
            this.myDrone.notifyDroneEvent(DroneInterfaces.DroneEventsType.TYPE);
        }
    }

    public int getType() {
        return this.type;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String message) {
        if (this.firmwareVersion == null || !this.firmwareVersion.equals(message)) {
            this.firmwareVersion = message;
            this.myDrone.notifyDroneEvent(DroneInterfaces.DroneEventsType.FIRMWARE);
        }
    }

    public static boolean isCopter(int type) {
        switch (type) {
            case 2: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPlane(int type) {
        return type == 1;
    }

    public static boolean isRover(int type) {
        return type == 10;
    }

    @Override
    public void onDroneEvent(DroneInterfaces.DroneEventsType event, MavLinkDrone drone) {
        switch (event) {
            case DISCONNECTED: {
                this.setType(0);
            }
        }
    }
}

