/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.profiles;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.util.SparseBooleanArray;
import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.common.msg_param_value;
import com.o3dr.services.android.lib.drone.property.Parameter;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.droidplanner.services.android.impl.core.MAVLink.MavLinkParameters;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneVariable;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.profiles.ParameterMetadata;
import org.droidplanner.services.android.impl.utils.file.IO.ParameterMetadataLoader;
import timber.log.Timber;

public class ParameterManager
extends DroneVariable<MavLinkDrone>
implements DroneInterfaces.OnDroneListener<MavLinkDrone> {
    private static final long TIMEOUT = 1000L;
    private final Runnable parametersReceiptStartNotification = new Runnable(){

        @Override
        public void run() {
            if (ParameterManager.this.parameterListener != null) {
                ParameterManager.this.parameterListener.onBeginReceivingParameters();
            }
        }
    };
    public final Runnable watchdogCallback = new Runnable(){

        @Override
        public void run() {
            ParameterManager.this.onParameterStreamStopped();
        }
    };
    private final Runnable parametersReceiptEndNotification = new Runnable(){

        @Override
        public void run() {
            if (ParameterManager.this.parameterListener != null) {
                ParameterManager.this.parameterListener.onEndReceivingParameters();
            }
        }
    };
    private final AtomicBoolean isRefreshing = new AtomicBoolean(false);
    private final ConcurrentLinkedQueue<String> paramsToReadFromVehicle = new ConcurrentLinkedQueue();
    private int expectedParams;
    private final SparseBooleanArray paramsRollCall = new SparseBooleanArray();
    private final ConcurrentHashMap<String, Parameter> parameters = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ParameterMetadata> parametersMetadata = new ConcurrentHashMap();
    private DroneInterfaces.OnParameterManagerListener parameterListener;
    private final Handler watchdog;
    private final Context context;

    public ParameterManager(MavLinkDrone myDrone, Context context, Handler handler) {
        super(myDrone);
        this.context = context;
        this.watchdog = handler;
        myDrone.addDroneListener(this);
        this.refreshParametersMetadata();
    }

    public void refreshParameters() {
        if (this.isRefreshing.compareAndSet(false, true)) {
            this.paramsToReadFromVehicle.clear();
            this.expectedParams = 0;
            this.parameters.clear();
            this.paramsRollCall.clear();
            this.notifyParametersReceiptStart();
            MavLinkParameters.requestParametersList(this.myDrone);
            this.resetWatchdog();
        }
    }

    public Map<String, Parameter> getParameters() {
        if (this.parameters.isEmpty()) {
            this.refreshParameters();
        }
        return this.parameters;
    }

    public boolean processMessage(MAVLinkMessage msg) {
        if (msg.msgid == 22) {
            this.processReceivedParam((msg_param_value)msg);
            return true;
        }
        return false;
    }

    protected void processReceivedParam(msg_param_value m_value) {
        String paramName = m_value.getParam_Id();
        if (!this.paramsToReadFromVehicle.remove(paramName) && !this.isRefreshing.get()) {
            return;
        }
        Parameter param = new Parameter(paramName, m_value.param_value, m_value.param_type);
        this.loadParameterMetadata(param);
        int paramIndex = m_value.param_index;
        this.parameters.put(param.getName().toLowerCase(Locale.US), param);
        if (paramIndex == -1) {
            this.notifyParameterReceipt(param, 0, 1);
            this.notifyParametersReceiptEnd();
            return;
        }
        this.paramsRollCall.append(paramIndex, true);
        this.expectedParams = m_value.param_count;
        this.notifyParameterReceipt(param, paramIndex, m_value.param_count);
        if (this.parameters.size() >= m_value.param_count) {
            if (this.isRefreshing.compareAndSet(true, false)) {
                this.killWatchdog();
            }
            this.notifyParametersReceiptEnd();
        } else {
            this.resetWatchdog();
        }
    }

    private void reRequestMissingParams(int howManyParams) {
        for (int i = 0; i < howManyParams; ++i) {
            if (this.paramsRollCall.get(i)) continue;
            MavLinkParameters.readParameter(this.myDrone, i);
        }
    }

    public void sendParameter(Parameter parameter) {
        this.paramsToReadFromVehicle.add(parameter.getName());
        MavLinkParameters.sendParameter(this.myDrone, parameter);
    }

    public void readParameter(String name) {
        this.paramsToReadFromVehicle.add(name);
        MavLinkParameters.readParameter(this.myDrone, name);
    }

    public Parameter getParameter(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        return this.parameters.get(name.toLowerCase(Locale.US));
    }

    private void onParameterStreamStopped() {
        if (this.expectedParams > 0) {
            this.reRequestMissingParams(this.expectedParams);
            this.resetWatchdog();
        } else {
            this.isRefreshing.set(false);
        }
    }

    private void resetWatchdog() {
        this.watchdog.removeCallbacks(this.watchdogCallback);
        this.watchdog.postDelayed(this.watchdogCallback, 1000L);
    }

    private void killWatchdog() {
        this.watchdog.removeCallbacks(this.watchdogCallback);
        this.isRefreshing.set(false);
    }

    @Override
    public void onDroneEvent(DroneInterfaces.DroneEventsType event, MavLinkDrone drone) {
        switch (event) {
            case HEARTBEAT_FIRST: {
                this.refreshParameters();
                break;
            }
            case DISCONNECTED: 
            case HEARTBEAT_TIMEOUT: {
                this.killWatchdog();
                break;
            }
            case TYPE: {
                this.refreshParametersMetadata();
                break;
            }
        }
    }

    private void refreshParametersMetadata() {
        String metadataType = this.myDrone.getFirmwareType().getParameterMetadataGroup();
        if (!TextUtils.isEmpty((CharSequence)metadataType)) {
            try {
                ParameterMetadataLoader.load(this.context, metadataType, this.parametersMetadata);
            }
            catch (Exception e) {
                Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
        if (this.parametersMetadata.isEmpty() || this.parameters.isEmpty()) {
            return;
        }
        for (Parameter parameter : this.parameters.values()) {
            this.loadParameterMetadata(parameter);
        }
    }

    private void loadParameterMetadata(Parameter parameter) {
        ParameterMetadata metadata = this.parametersMetadata.get(parameter.getName());
        if (metadata != null) {
            parameter.setDisplayName(metadata.getDisplayName());
            parameter.setDescription(metadata.getDescription());
            parameter.setUnits(metadata.getUnits());
            parameter.setRange(metadata.getRange());
            parameter.setValues(metadata.getValues());
        }
    }

    public void setParameterListener(DroneInterfaces.OnParameterManagerListener parameterListener) {
        this.parameterListener = parameterListener;
    }

    private void notifyParametersReceiptStart() {
        if (this.parameterListener != null) {
            this.watchdog.post(this.parametersReceiptStartNotification);
        }
    }

    private void notifyParametersReceiptEnd() {
        if (this.parameterListener != null) {
            this.watchdog.post(this.parametersReceiptEndNotification);
        }
    }

    private void notifyParameterReceipt(final Parameter parameter, final int index, final int count) {
        if (this.parameterListener != null) {
            this.watchdog.post(new Runnable(){

                @Override
                public void run() {
                    if (ParameterManager.this.parameterListener != null) {
                        ParameterManager.this.parameterListener.onParameterReceived(parameter, index, count);
                    }
                }
            });
        }
    }
}

