/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.MAVLink.connection;

import android.content.Context;
import android.os.Bundle;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.droidplanner.services.android.impl.core.MAVLink.connection.MavLinkConnection;
import org.droidplanner.services.android.impl.utils.NetworkUtils;

public abstract class UdpConnection
extends MavLinkConnection {
    private AtomicReference<DatagramSocket> socketRef = new AtomicReference();
    private int serverPort;
    private int hostPort;
    private InetAddress hostAdd;
    private DatagramPacket sendPacket;
    private DatagramPacket receivePacket;

    protected UdpConnection(Context context) {
        super(context);
    }

    private void getUdpStream(Bundle extras) throws IOException {
        DatagramSocket socket = new DatagramSocket(this.serverPort);
        socket.setBroadcast(true);
        socket.setReuseAddress(true);
        NetworkUtils.bindSocketToNetwork(extras, socket);
        this.socketRef.set(socket);
    }

    @Override
    public final void closeConnection() throws IOException {
        DatagramSocket socket = this.socketRef.get();
        if (socket != null) {
            socket.close();
        }
    }

    @Override
    public final void openConnection(Bundle connectionExtras) throws IOException {
        this.getUdpStream(connectionExtras);
        this.onConnectionOpened(connectionExtras);
    }

    @Override
    public final void sendBuffer(byte[] buffer) throws IOException {
        DatagramSocket socket = this.socketRef.get();
        if (socket == null) {
            return;
        }
        try {
            if (this.hostAdd != null) {
                if (this.sendPacket == null) {
                    this.sendPacket = new DatagramPacket(buffer, buffer.length, this.hostAdd, this.hostPort);
                } else {
                    this.sendPacket.setData(buffer, 0, buffer.length);
                    this.sendPacket.setAddress(this.hostAdd);
                    this.sendPacket.setPort(this.hostPort);
                }
                socket.send(this.sendPacket);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendBuffer(InetAddress targetAddr, int targetPort, byte[] buffer) throws IOException {
        DatagramSocket socket = this.socketRef.get();
        if (socket == null || targetAddr == null || buffer == null) {
            return;
        }
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, targetAddr, targetPort);
        socket.send(packet);
    }

    @Override
    public final int readDataBlock(byte[] readData) throws IOException {
        DatagramSocket socket = this.socketRef.get();
        if (socket == null) {
            return 0;
        }
        if (this.receivePacket == null) {
            this.receivePacket = new DatagramPacket(readData, readData.length);
        } else {
            this.receivePacket.setData(readData);
        }
        socket.receive(this.receivePacket);
        this.hostAdd = this.receivePacket.getAddress();
        this.hostPort = this.receivePacket.getPort();
        return this.receivePacket.getLength();
    }

    @Override
    public final void loadPreferences() {
        this.serverPort = this.loadServerPort();
    }

    @Override
    public final int getConnectionType() {
        return 1;
    }

    protected abstract int loadServerPort();
}

