/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.property;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import java.io.Serializable;
import java.util.BitSet;

public class EkfStatus
implements DroneAttribute {
    private static final int FLAGS_BIT_COUNT = 16;
    private float velocityVariance;
    private float horizontalPositionVariance;
    private float verticalPositionVariance;
    private float compassVariance;
    private float terrainAltitudeVariance;
    private final BitSet flags;
    public static final Parcelable.Creator<EkfStatus> CREATOR = new Parcelable.Creator<EkfStatus>(){

        public EkfStatus createFromParcel(Parcel source) {
            return new EkfStatus(source);
        }

        public EkfStatus[] newArray(int size) {
            return new EkfStatus[size];
        }
    };

    public EkfStatus() {
        this.flags = new BitSet(16);
    }

    public EkfStatus(int flags, float compassVariance, float horizontalPositionVariance, float terrainAltitudeVariance, float velocityVariance, float verticalPositionVariance) {
        this();
        this.compassVariance = compassVariance;
        this.horizontalPositionVariance = horizontalPositionVariance;
        this.terrainAltitudeVariance = terrainAltitudeVariance;
        this.velocityVariance = velocityVariance;
        this.verticalPositionVariance = verticalPositionVariance;
        this.fromShortToBitSet(flags);
    }

    private void fromShortToBitSet(int flags) {
        EkfFlags[] ekfFlags = EkfFlags.values();
        int ekfFlagsCount = ekfFlags.length;
        for (int i = 0; i < ekfFlagsCount; ++i) {
            this.flags.set(i, (flags & ekfFlags[i].value) != 0);
        }
    }

    public float getTerrainAltitudeVariance() {
        return this.terrainAltitudeVariance;
    }

    public void setTerrainAltitudeVariance(float terrainAltitudeVariance) {
        this.terrainAltitudeVariance = terrainAltitudeVariance;
    }

    public float getVelocityVariance() {
        return this.velocityVariance;
    }

    public void setVelocityVariance(float velocityVariance) {
        this.velocityVariance = velocityVariance;
    }

    public float getVerticalPositionVariance() {
        return this.verticalPositionVariance;
    }

    public void setVerticalPositionVariance(float verticalPositionVariance) {
        this.verticalPositionVariance = verticalPositionVariance;
    }

    public float getHorizontalPositionVariance() {
        return this.horizontalPositionVariance;
    }

    public void setHorizontalPositionVariance(float horizontalPositionVariance) {
        this.horizontalPositionVariance = horizontalPositionVariance;
    }

    public float getCompassVariance() {
        return this.compassVariance;
    }

    public void setCompassVariance(float compassVariance) {
        this.compassVariance = compassVariance;
    }

    public boolean isEkfFlagSet(EkfFlags flag) {
        return this.flags.get(flag.ordinal());
    }

    public boolean isPositionOk(boolean armed) {
        if (armed) {
            return this.flags.get(EkfFlags.EKF_POS_HORIZ_ABS.ordinal()) && !this.flags.get(EkfFlags.EKF_CONST_POS_MODE.ordinal());
        }
        return this.flags.get(EkfFlags.EKF_POS_HORIZ_ABS.ordinal()) || this.flags.get(EkfFlags.EKF_PRED_POS_HORIZ_ABS.ordinal());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.velocityVariance);
        dest.writeFloat(this.horizontalPositionVariance);
        dest.writeFloat(this.verticalPositionVariance);
        dest.writeFloat(this.compassVariance);
        dest.writeFloat(this.terrainAltitudeVariance);
        dest.writeSerializable((Serializable)this.flags);
    }

    private EkfStatus(Parcel in) {
        this.velocityVariance = in.readFloat();
        this.horizontalPositionVariance = in.readFloat();
        this.verticalPositionVariance = in.readFloat();
        this.compassVariance = in.readFloat();
        this.terrainAltitudeVariance = in.readFloat();
        this.flags = (BitSet)in.readSerializable();
    }

    public static enum EkfFlags {
        EKF_ATTITUDE(1),
        EKF_VELOCITY_HORIZ(2),
        EKF_VELOCITY_VERT(4),
        EKF_POS_HORIZ_REL(8),
        EKF_POS_HORIZ_ABS(16),
        EKF_POS_VERT_ABS(32),
        EKF_POS_VERT_AGL(64),
        EKF_CONST_POS_MODE(128),
        EKF_PRED_POS_HORIZ_REL(256),
        EKF_PRED_POS_HORIZ_ABS(512);

        final int value;

        private EkfFlags(int value) {
            this.value = value;
        }
    }
}

