/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.mission.item.spatial;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.mission.MissionItemType;
import com.o3dr.services.android.lib.drone.mission.item.MissionItem;
import com.o3dr.services.android.lib.drone.mission.item.spatial.BaseSpatialItem;

public class Circle
extends BaseSpatialItem
implements Parcelable {
    private double radius = 10.0;
    private int turns = 1;
    public static final Parcelable.Creator<Circle> CREATOR = new Parcelable.Creator<Circle>(){

        public Circle createFromParcel(Parcel source) {
            return new Circle(source);
        }

        public Circle[] newArray(int size) {
            return new Circle[size];
        }
    };

    public Circle() {
        super(MissionItemType.CIRCLE);
    }

    public Circle(Circle copy) {
        super(copy);
        this.radius = copy.radius;
        this.turns = copy.turns;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public int getTurns() {
        return this.turns;
    }

    public void setTurns(int turns) {
        this.turns = turns;
    }

    @Override
    public String toString() {
        return "Circle{radius=" + this.radius + ", turns=" + this.turns + ", " + super.toString() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Circle)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Circle circle = (Circle)o;
        if (Double.compare(circle.radius, this.radius) != 0) {
            return false;
        }
        return this.turns == circle.turns;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.radius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.turns;
        return result;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeDouble(this.radius);
        dest.writeInt(this.turns);
    }

    private Circle(Parcel in) {
        super(in);
        this.radius = in.readDouble();
        this.turns = in.readInt();
    }

    @Override
    public MissionItem clone() {
        return new Circle(this);
    }
}

