/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.mission;

import android.os.Bundle;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.mission.item.MissionItem;
import com.o3dr.services.android.lib.drone.mission.item.command.CameraTrigger;
import com.o3dr.services.android.lib.drone.mission.item.command.ChangeSpeed;
import com.o3dr.services.android.lib.drone.mission.item.command.DoJump;
import com.o3dr.services.android.lib.drone.mission.item.command.EpmGripper;
import com.o3dr.services.android.lib.drone.mission.item.command.ResetROI;
import com.o3dr.services.android.lib.drone.mission.item.command.ReturnToLaunch;
import com.o3dr.services.android.lib.drone.mission.item.command.SetRelay;
import com.o3dr.services.android.lib.drone.mission.item.command.SetServo;
import com.o3dr.services.android.lib.drone.mission.item.command.Takeoff;
import com.o3dr.services.android.lib.drone.mission.item.command.YawCondition;
import com.o3dr.services.android.lib.drone.mission.item.complex.SplineSurvey;
import com.o3dr.services.android.lib.drone.mission.item.complex.StructureScanner;
import com.o3dr.services.android.lib.drone.mission.item.complex.Survey;
import com.o3dr.services.android.lib.drone.mission.item.spatial.Circle;
import com.o3dr.services.android.lib.drone.mission.item.spatial.DoLandStart;
import com.o3dr.services.android.lib.drone.mission.item.spatial.Land;
import com.o3dr.services.android.lib.drone.mission.item.spatial.RegionOfInterest;
import com.o3dr.services.android.lib.drone.mission.item.spatial.SplineWaypoint;
import com.o3dr.services.android.lib.drone.mission.item.spatial.Waypoint;
import com.o3dr.services.android.lib.drone.property.Type;
import com.o3dr.services.android.lib.util.ParcelableUtils;

public enum MissionItemType {
    WAYPOINT("Waypoint"){

        @Override
        public MissionItem getNewItem() {
            return new Waypoint();
        }

        protected Parcelable.Creator<Waypoint> getMissionItemCreator() {
            return Waypoint.CREATOR;
        }
    }
    ,
    SPLINE_WAYPOINT("Spline Waypoint"){

        @Override
        public MissionItem getNewItem() {
            return new SplineWaypoint();
        }

        protected Parcelable.Creator<SplineWaypoint> getMissionItemCreator() {
            return SplineWaypoint.CREATOR;
        }
    }
    ,
    TAKEOFF("Takeoff"){

        @Override
        public MissionItem getNewItem() {
            return new Takeoff();
        }

        protected Parcelable.Creator<Takeoff> getMissionItemCreator() {
            return Takeoff.CREATOR;
        }
    }
    ,
    CHANGE_SPEED("Change Speed"){

        @Override
        public MissionItem getNewItem() {
            return new ChangeSpeed();
        }

        protected Parcelable.Creator<ChangeSpeed> getMissionItemCreator() {
            return ChangeSpeed.CREATOR;
        }
    }
    ,
    CAMERA_TRIGGER("Camera Trigger"){

        @Override
        public MissionItem getNewItem() {
            return new CameraTrigger();
        }

        protected Parcelable.Creator<CameraTrigger> getMissionItemCreator() {
            return CameraTrigger.CREATOR;
        }
    }
    ,
    EPM_GRIPPER("EPM Gripper"){

        @Override
        public MissionItem getNewItem() {
            return new EpmGripper();
        }

        protected Parcelable.Creator<EpmGripper> getMissionItemCreator() {
            return EpmGripper.CREATOR;
        }
    }
    ,
    RETURN_TO_LAUNCH("Return to Launch"){

        @Override
        public MissionItem getNewItem() {
            return new ReturnToLaunch();
        }

        protected Parcelable.Creator<ReturnToLaunch> getMissionItemCreator() {
            return ReturnToLaunch.CREATOR;
        }
    }
    ,
    LAND("Land"){

        @Override
        public MissionItem getNewItem() {
            return new Land();
        }

        protected Parcelable.Creator<Land> getMissionItemCreator() {
            return Land.CREATOR;
        }
    }
    ,
    CIRCLE("Circle"){

        @Override
        public MissionItem getNewItem() {
            return new Circle();
        }

        protected Parcelable.Creator<Circle> getMissionItemCreator() {
            return Circle.CREATOR;
        }
    }
    ,
    REGION_OF_INTEREST("Region of Interest"){

        @Override
        public MissionItem getNewItem() {
            return new RegionOfInterest();
        }

        protected Parcelable.Creator<RegionOfInterest> getMissionItemCreator() {
            return RegionOfInterest.CREATOR;
        }
    }
    ,
    SURVEY("Survey"){

        @Override
        public MissionItem getNewItem() {
            return new Survey();
        }

        protected Parcelable.Creator<Survey> getMissionItemCreator() {
            return Survey.CREATOR;
        }
    }
    ,
    STRUCTURE_SCANNER("Structure Scanner"){

        @Override
        public MissionItem getNewItem() {
            return new StructureScanner();
        }

        protected Parcelable.Creator<StructureScanner> getMissionItemCreator() {
            return StructureScanner.CREATOR;
        }
    }
    ,
    SET_SERVO("Set Servo"){

        @Override
        public MissionItem getNewItem() {
            return new SetServo();
        }

        protected Parcelable.Creator<SetServo> getMissionItemCreator() {
            return SetServo.CREATOR;
        }
    }
    ,
    YAW_CONDITION("Set Yaw"){

        @Override
        public MissionItem getNewItem() {
            return new YawCondition();
        }

        protected Parcelable.Creator<YawCondition> getMissionItemCreator() {
            return YawCondition.CREATOR;
        }
    }
    ,
    SET_RELAY("Set Relay"){

        @Override
        public MissionItem getNewItem() {
            return new SetRelay();
        }

        protected Parcelable.Creator<SetRelay> getMissionItemCreator() {
            return SetRelay.CREATOR;
        }
    }
    ,
    DO_LAND_START("Do Land start"){

        @Override
        public boolean isTypeSupported(Type vehicleType) {
            return super.isTypeSupported(vehicleType) && vehicleType.getDroneType() == 1;
        }

        @Override
        public MissionItem getNewItem() {
            return new DoLandStart();
        }

        protected Parcelable.Creator<DoLandStart> getMissionItemCreator() {
            return DoLandStart.CREATOR;
        }
    }
    ,
    SPLINE_SURVEY("Spline Survey"){

        @Override
        public MissionItem getNewItem() {
            return new SplineSurvey();
        }

        protected Parcelable.Creator<SplineSurvey> getMissionItemCreator() {
            return SplineSurvey.CREATOR;
        }
    }
    ,
    DO_JUMP("Do Jump"){

        @Override
        public MissionItem getNewItem() {
            return new DoJump();
        }

        protected Parcelable.Creator<DoJump> getMissionItemCreator() {
            return DoJump.CREATOR;
        }
    }
    ,
    RESET_ROI("Reset ROI"){

        @Override
        public MissionItem getNewItem() {
            return new ResetROI();
        }

        protected Parcelable.Creator<ResetROI> getMissionItemCreator() {
            return ResetROI.CREATOR;
        }
    };

    private static final String EXTRA_MISSION_ITEM_TYPE = "extra_mission_item_type";
    private static final String EXTRA_MISSION_ITEM = "extra_mission_item";
    private final String label;

    private MissionItemType(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }

    public abstract MissionItem getNewItem();

    public final Bundle storeMissionItem(MissionItem item) {
        Bundle bundle = new Bundle(2);
        this.storeMissionItem(item, bundle);
        return bundle;
    }

    public void storeMissionItem(MissionItem missionItem, Bundle bundle) {
        bundle.putString(EXTRA_MISSION_ITEM_TYPE, this.name());
        bundle.putByteArray(EXTRA_MISSION_ITEM, ParcelableUtils.marshall(missionItem));
    }

    protected abstract <T extends MissionItem> Parcelable.Creator<T> getMissionItemCreator();

    public static <T extends MissionItem> T restoreMissionItemFromBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        String typeName = bundle.getString(EXTRA_MISSION_ITEM_TYPE);
        byte[] marshalledItem = bundle.getByteArray(EXTRA_MISSION_ITEM);
        if (typeName == null || marshalledItem == null) {
            return null;
        }
        MissionItemType type = MissionItemType.valueOf(typeName);
        if (type == null) {
            return null;
        }
        MissionItem missionItem = (MissionItem)ParcelableUtils.unmarshall(marshalledItem, type.getMissionItemCreator());
        return (T)missionItem;
    }

    public boolean isTypeSupported(Type vehicleType) {
        return vehicleType != null;
    }
}

