/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo.tlv.sitescan.inspect;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import java.nio.ByteBuffer;

public class SoloInspectSetWaypoint
extends TLVPacket {
    private float lat;
    private float lon;
    private float alt;
    public static final Parcelable.Creator<SoloInspectSetWaypoint> CREATOR = new Parcelable.Creator<SoloInspectSetWaypoint>(){

        public SoloInspectSetWaypoint createFromParcel(Parcel source) {
            return new SoloInspectSetWaypoint(source);
        }

        public SoloInspectSetWaypoint[] newArray(int size) {
            return new SoloInspectSetWaypoint[size];
        }
    };

    public SoloInspectSetWaypoint(float lat, float lon, float alt) {
        super(10002, 12);
        this.lat = lat;
        this.lon = lon;
        this.alt = alt;
    }

    public SoloInspectSetWaypoint(ByteBuffer buffer) {
        this(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
    }

    public float getLat() {
        return this.lat;
    }

    public float getLon() {
        return this.lon;
    }

    public float getAlt() {
        return this.alt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoloInspectSetWaypoint)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SoloInspectSetWaypoint that = (SoloInspectSetWaypoint)o;
        if (Float.compare(that.lat, this.lat) != 0) {
            return false;
        }
        if (Float.compare(that.lon, this.lon) != 0) {
            return false;
        }
        return Float.compare(that.alt, this.alt) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.lat != 0.0f ? Float.floatToIntBits(this.lat) : 0);
        result = 31 * result + (this.lon != 0.0f ? Float.floatToIntBits(this.lon) : 0);
        result = 31 * result + (this.alt != 0.0f ? Float.floatToIntBits(this.alt) : 0);
        return result;
    }

    @Override
    protected void getMessageValue(ByteBuffer valueCarrier) {
        valueCarrier.putFloat(this.lat);
        valueCarrier.putFloat(this.lon);
        valueCarrier.putFloat(this.alt);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeFloat(this.lat);
        dest.writeFloat(this.lon);
        dest.writeFloat(this.alt);
    }

    protected SoloInspectSetWaypoint(Parcel in) {
        super(in);
        this.lat = in.readFloat();
        this.lon = in.readFloat();
        this.alt = in.readFloat();
    }
}

