/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo.tlv;

import android.os.Parcel;
import android.os.Parcelable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class TLVPacket
implements Parcelable {
    public static final int MIN_TLV_PACKET_SIZE = 8;
    public static final ByteOrder TLV_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final int messageType;
    private final int messageLength;
    private final ByteBuffer byteBuffer;

    public TLVPacket(int type, int length) {
        this.messageType = type;
        this.messageLength = length;
        this.byteBuffer = ByteBuffer.allocate(8 + this.messageLength);
        this.byteBuffer.order(TLV_BYTE_ORDER);
    }

    public final int getMessageType() {
        return this.messageType;
    }

    public final int getMessageLength() {
        return this.messageLength;
    }

    public final byte[] toBytes() {
        this.byteBuffer.clear();
        this.byteBuffer.putInt(this.messageType);
        this.byteBuffer.putInt(this.messageLength);
        this.getMessageValue(this.byteBuffer);
        byte[] bytes = new byte[this.byteBuffer.position()];
        this.byteBuffer.rewind();
        this.byteBuffer.get(bytes);
        return bytes;
    }

    public String toString() {
        return "TLVPacket{messageLength=" + this.messageLength + ", messageType=" + this.messageType + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TLVPacket)) {
            return false;
        }
        TLVPacket tlvPacket = (TLVPacket)o;
        if (this.messageType != tlvPacket.messageType) {
            return false;
        }
        return this.messageLength == tlvPacket.messageLength;
    }

    public int hashCode() {
        int result = this.messageType;
        result = 31 * result + this.messageLength;
        return result;
    }

    protected abstract void getMessageValue(ByteBuffer var1);

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.messageType);
        dest.writeInt(this.messageLength);
    }

    protected TLVPacket(Parcel in) {
        this(in.readInt(), in.readInt());
    }
}

