/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo.button;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ButtonPacket
implements Parcelable {
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private static final String TAG = ButtonPacket.class.getSimpleName();
    private double timestamp = -1.0;
    private byte eventType = (byte)-1;
    private byte buttonId = (byte)-1;
    private short pressedMask = (short)-1;
    private final ByteBuffer byteBuffer;
    public static final Parcelable.Creator<ButtonPacket> CREATOR = new Parcelable.Creator<ButtonPacket>(){

        public ButtonPacket createFromParcel(Parcel source) {
            return new ButtonPacket(source);
        }

        public ButtonPacket[] newArray(int size) {
            return new ButtonPacket[size];
        }
    };

    public ButtonPacket(short pressedMask, byte buttonId, byte eventType, double timestamp) {
        this.pressedMask = pressedMask;
        this.buttonId = buttonId;
        this.eventType = eventType;
        this.timestamp = timestamp;
        this.byteBuffer = ByteBuffer.allocate(12);
        this.byteBuffer.order(BYTE_ORDER);
    }

    private ButtonPacket(Parcel in) {
        this.timestamp = in.readDouble();
        this.eventType = in.readByte();
        this.buttonId = in.readByte();
        this.pressedMask = (Short)in.readValue(Short.TYPE.getClassLoader());
        this.byteBuffer = ByteBuffer.allocate(12);
        this.byteBuffer.order(BYTE_ORDER);
    }

    public final int getEventType() {
        return this.eventType;
    }

    public final byte[] toBytes() {
        this.byteBuffer.clear();
        this.byteBuffer.putDouble(this.timestamp);
        this.byteBuffer.put(this.buttonId);
        this.byteBuffer.put(this.eventType);
        this.byteBuffer.putShort(this.pressedMask);
        byte[] bytes = new byte[this.byteBuffer.position()];
        this.byteBuffer.rewind();
        this.byteBuffer.get(bytes);
        return bytes;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public byte getButtonId() {
        return this.buttonId;
    }

    public short getPressedMask() {
        return this.pressedMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ButtonPacket parseButtonPacket(ByteBuffer packetBuffer) {
        if (packetBuffer == null || packetBuffer.limit() <= 0) {
            return null;
        }
        ByteOrder originalOrder = packetBuffer.order();
        try {
            packetBuffer.order(BYTE_ORDER);
            double timestamp = packetBuffer.getDouble();
            byte buttonId = packetBuffer.get();
            byte eventType = packetBuffer.get();
            short pressedMask = packetBuffer.getShort();
            ButtonPacket buttonPacket = new ButtonPacket(pressedMask, buttonId, eventType, timestamp);
            return buttonPacket;
        }
        catch (BufferUnderflowException e) {
            Log.e((String)TAG, (String)"Invalid data for button packet", (Throwable)e);
            ButtonPacket buttonPacket = null;
            return buttonPacket;
        }
        finally {
            packetBuffer.order(originalOrder);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.timestamp);
        dest.writeByte(this.eventType);
        dest.writeByte(this.buttonId);
        dest.writeValue((Object)this.pressedMask);
    }
}

