/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.utils.data.tlog;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import com.MAVLink.MAVLinkPacket;
import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.Parser;
import com.o3dr.android.client.utils.data.tlog.TLogIteratorCallback;
import com.o3dr.android.client.utils.data.tlog.TLogIteratorFilter;
import com.o3dr.android.client.utils.data.tlog.TLogParserCallback;
import com.o3dr.android.client.utils.data.tlog.TLogParserFilter;
import com.o3dr.services.android.lib.util.UriUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TLogParser {
    private static final String LOG_TAG = TLogParser.class.getSimpleName();
    private static final Parser parser = new Parser();
    private static final TLogParserFilter DEFAULT_FILTER = new TLogParserFilter(){

        @Override
        public boolean includeEvent(Event e) {
            return true;
        }

        @Override
        public boolean shouldIterate() {
            return true;
        }
    };

    private TLogParser() {
    }

    public static List<Event> getAllEvents(Context context, Uri uri) throws Exception {
        return TLogParser.getAllEvents(context, uri, DEFAULT_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Event> getAllEvents(Context context, Uri uri, TLogParserFilter filter) throws Exception {
        InputStream inputStream = UriUtils.getInputStream(context, uri);
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(inputStream));
            ArrayList<Event> eventList = new ArrayList<Event>();
            Event event = TLogParser.next((DataInputStream)in);
            while (event != null && filter.shouldIterate()) {
                if (filter.includeEvent(event)) {
                    eventList.add(event);
                }
                event = TLogParser.next((DataInputStream)in);
            }
            ArrayList<Event> arrayList = eventList;
            return arrayList;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Log.e((String)LOG_TAG, (String)("Failed to close file " + uri), (Throwable)e);
                }
            }
        }
    }

    public static void getAllEventsAsync(Context context, Handler handler, Uri uri, TLogParserCallback callback) {
        TLogParser.getAllEventsAsync(context, handler, uri, DEFAULT_FILTER, callback);
    }

    public static void getAllEventsAsync(final Context context, final Handler handler, final Uri uri, final TLogParserFilter filter, final TLogParserCallback callback) {
        TLogParser.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<Event> eventList = TLogParser.getAllEvents(context, uri, filter);
                    if (eventList.isEmpty()) {
                        TLogParser.sendFailed(handler, callback, new NoSuchElementException());
                    } else {
                        TLogParser.sendResult(handler, callback, eventList);
                    }
                }
                catch (Exception e) {
                    TLogParser.sendFailed(handler, callback, e);
                }
            }
        });
    }

    private static void sendResult(Handler handler, final TLogParserCallback callback, final List<Event> events) {
        if (callback != null) {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onResult(events);
                }
            });
        }
    }

    private static void sendFailed(Handler handler, final TLogParserCallback callback, final Exception e) {
        if (callback != null) {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onFailed(e);
                }
            });
        }
    }

    private static Event next(DataInputStream in) throws IOException {
        try {
            MAVLinkPacket packet;
            long timestamp = in.readLong() / 1000L;
            while ((packet = parser.mavlink_parse_char(in.readUnsignedByte())) == null) {
            }
            MAVLinkMessage message = packet.unpack();
            if (message == null) {
                return null;
            }
            return new Event(timestamp, message);
        }
        catch (EOFException e) {
            return null;
        }
    }

    private static ExecutorService getInstance() {
        return InitializeExecutorService.executorService;
    }

    public static class Event
    implements Serializable {
        private static final long serialVersionUID = -3035618718582382608L;
        private long timestamp;
        private MAVLinkMessage mavLinkMessage;

        private Event(long timestamp, MAVLinkMessage mavLinkMessage) {
            this.timestamp = timestamp;
            this.mavLinkMessage = mavLinkMessage;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public MAVLinkMessage getMavLinkMessage() {
            return this.mavLinkMessage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Event)) {
                return false;
            }
            Event event = (Event)o;
            if (this.timestamp != event.timestamp) {
                return false;
            }
            return this.mavLinkMessage != null ? this.mavLinkMessage.equals(event.mavLinkMessage) : event.mavLinkMessage == null;
        }

        public int hashCode() {
            int result = (int)(this.timestamp ^ this.timestamp >>> 32);
            result = 31 * result + (this.mavLinkMessage != null ? this.mavLinkMessage.hashCode() : 0);
            return result;
        }
    }

    private static class InitializeExecutorService {
        private static final ExecutorService executorService = Executors.newSingleThreadExecutor();

        private InitializeExecutorService() {
        }
    }

    public static class TLogIterator {
        private final Context context;
        private final Uri uri;
        private DataInputStream in = null;
        private final Handler handler;
        private static final TLogIteratorFilter DEFAULT_FILTER = new TLogIteratorFilter(){

            @Override
            public boolean acceptEvent(Event event) {
                return true;
            }
        };

        public TLogIterator(Context context, Uri uri) {
            this(context, uri, new Handler());
        }

        public TLogIterator(Context context, Uri uri, Handler handler) {
            this.context = context;
            this.handler = handler;
            this.uri = uri;
        }

        public void start() throws IOException {
            this.in = new DataInputStream(new BufferedInputStream(UriUtils.getInputStream(this.context, this.uri)));
        }

        public void finish() throws IOException {
            this.in.close();
        }

        public void nextAsync(TLogIteratorCallback callback) {
            this.nextAsync(DEFAULT_FILTER, callback);
        }

        public void nextAsync(final TLogIteratorFilter filter, final TLogIteratorCallback callback) {
            TLogParser.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Event event = TLogIterator.this.blockingNext(filter);
                        if (event != null) {
                            TLogIterator.this.sendResult(callback, event);
                        } else {
                            TLogIterator.this.sendFailed(callback, new NoSuchElementException());
                        }
                    }
                    catch (IOException e) {
                        TLogIterator.this.sendFailed(callback, e);
                    }
                }
            });
        }

        public Event blockingNext() throws IOException {
            return this.blockingNext(DEFAULT_FILTER);
        }

        public Event blockingNext(TLogIteratorFilter filter) throws IOException {
            Event event = TLogParser.next(this.in);
            while (event != null) {
                if (filter.acceptEvent(event)) {
                    return event;
                }
                event = TLogParser.next(this.in);
            }
            return null;
        }

        private void sendResult(final TLogIteratorCallback callback, final Event event) {
            if (callback != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onResult(event);
                    }
                });
            }
        }

        private void sendFailed(final TLogIteratorCallback callback, final Exception e) {
            if (callback != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFailed(e);
                    }
                });
            }
        }
    }
}

