/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.apis;

import android.os.Bundle;
import android.os.Parcelable;
import com.o3dr.android.client.Drone;
import com.o3dr.android.client.apis.Api;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import com.o3dr.services.android.lib.drone.connection.ConnectionParameter;
import com.o3dr.services.android.lib.drone.property.Parameters;
import com.o3dr.services.android.lib.drone.property.VehicleMode;
import com.o3dr.services.android.lib.model.AbstractCommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.concurrent.ConcurrentHashMap;

public class VehicleApi
extends Api {
    private static final ConcurrentHashMap<Drone, VehicleApi> vehicleApiCache = new ConcurrentHashMap();
    private static final Api.Builder<VehicleApi> apiBuilder = new Api.Builder<VehicleApi>(){

        @Override
        public VehicleApi build(Drone drone) {
            return new VehicleApi(drone);
        }
    };
    private final Drone drone;

    public static VehicleApi getApi(Drone drone) {
        return VehicleApi.getApi(drone, vehicleApiCache, apiBuilder);
    }

    private VehicleApi(Drone drone) {
        this.drone = drone;
    }

    public void connect(ConnectionParameter parameter) {
        Bundle params = new Bundle();
        params.putParcelable("extra_connect_parameter", (Parcelable)parameter);
        Action connectAction = new Action("com.o3dr.services.android.action.CONNECT", params);
        this.drone.performAsyncAction(connectAction);
    }

    public void disconnect() {
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.DISCONNECT"));
    }

    public void arm(boolean arm) {
        this.arm(arm, null);
    }

    public void arm(boolean arm, AbstractCommandListener listener) {
        this.arm(arm, false, listener);
    }

    public void arm(boolean arm, boolean emergencyDisarm, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putBoolean("extra_arm", arm);
        params.putBoolean("extra_emergency_disarm", emergencyDisarm);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.ARM", params), listener);
    }

    public void setVehicleMode(VehicleMode newMode) {
        this.setVehicleMode(newMode, null);
    }

    public void setVehicleMode(VehicleMode newMode, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putParcelable("extra_vehicle_mode", (Parcelable)newMode);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.SET_VEHICLE_MODE", params), listener);
    }

    public void refreshParameters() {
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.REFRESH_PARAMETERS"));
    }

    public void writeParameters(Parameters parameters) {
        Bundle params = new Bundle();
        params.putParcelable("extra_parameters", (Parcelable)parameters);
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.WRITE_PARAMETERS", params));
    }

    public void setVehicleHome(LatLongAlt homeLocation, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putParcelable("extra_vehicle_home_location", (Parcelable)homeLocation);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.SET_VEHICLE_HOME", params), listener);
    }

    public void enableReturnToMe(boolean isEnabled, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putBoolean("extra_is_return_to_me_enabled", isEnabled);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.ENABLE_RETURN_TO_ME", params), listener);
    }

    public void updateVehicleDataStreamRate(int rate, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putInt("extra_vehicle_data_stream_rate", rate);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.action.state.action.UPDATE_VEHICLE_DATA_STREAM_RATE", params), listener);
    }
}

