/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.apis;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.o3dr.android.client.Drone;
import com.o3dr.android.client.apis.Api;
import com.o3dr.services.android.lib.drone.mission.Mission;
import com.o3dr.services.android.lib.drone.mission.MissionItemType;
import com.o3dr.services.android.lib.drone.mission.item.MissionItem;
import com.o3dr.services.android.lib.model.AbstractCommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.concurrent.ConcurrentHashMap;

public class MissionApi
extends Api {
    private static final ConcurrentHashMap<Drone, MissionApi> missionApiCache = new ConcurrentHashMap();
    private static final Api.Builder<MissionApi> apiBuilder = new Api.Builder<MissionApi>(){

        @Override
        public MissionApi build(Drone drone) {
            return new MissionApi(drone);
        }
    };
    private final Drone drone;

    public static MissionApi getApi(Drone drone) {
        return MissionApi.getApi(drone, missionApiCache, apiBuilder);
    }

    private MissionApi(Drone drone) {
        this.drone = drone;
    }

    public void generateDronie() {
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.GENERATE_DRONIE"));
    }

    public void setMission(Mission mission, boolean pushToDrone) {
        Bundle params = new Bundle();
        params.putParcelable("extra_mission", (Parcelable)mission);
        params.putBoolean("extra_push_to_drone", pushToDrone);
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.SET_MISSION", params));
    }

    public void startMission(boolean forceModeChange, boolean forceArm, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putBoolean("extra_force_mode_change", forceModeChange);
        params.putBoolean("extra_force_arm", forceArm);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.START_MISSION", params), listener);
    }

    public void gotoWaypoint(int waypoint, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putInt("extra_mission_item_index", waypoint);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.GOTO_WAYPOINT", params), listener);
    }

    public void loadWaypoints() {
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.LOAD_WAYPOINTS"));
    }

    @Nullable
    public void loadMission(Uri sourceUri, LoadingCallback<Mission> loadingCallback) {
        this.loadAndSetMission(sourceUri, false, loadingCallback);
    }

    public void loadAndSetMission(Uri sourceUri, LoadingCallback<Mission> loadingCallback) {
        this.loadAndSetMission(sourceUri, true, loadingCallback);
    }

    private void loadAndSetMission(final Uri sourceUri, final boolean setMission, final LoadingCallback<Mission> loadingCallback) {
        if (sourceUri == null) {
            throw new NullPointerException("Mission source uri must be non null.");
        }
        if (!setMission && loadingCallback == null) {
            return;
        }
        this.drone.getAsyncScheduler().execute(new Runnable(){

            @Override
            public void run() {
                MissionApi.this.postLoadingStart(loadingCallback);
                Bundle params = new Bundle();
                params.putParcelable("extra_load_mission_uri", (Parcelable)sourceUri);
                params.putBoolean("extra_set_loaded_mission", setMission);
                Action loadAction = new Action("com.o3dr.services.android.action.LOAD_MISSION", params);
                boolean result = MissionApi.this.drone.performAction(loadAction);
                if (loadingCallback != null) {
                    if (result) {
                        Mission loadedMission = (Mission)loadAction.getData().getParcelable("extra_mission");
                        if (loadedMission == null) {
                            MissionApi.this.postLoadingFailed(loadingCallback);
                        } else {
                            MissionApi.this.postLoadingComplete(loadedMission, loadingCallback);
                        }
                    } else {
                        MissionApi.this.postLoadingFailed(loadingCallback);
                    }
                }
            }
        });
    }

    private void postLoadingStart(final LoadingCallback<?> callback) {
        if (callback != null) {
            this.drone.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    callback.onLoadingStart();
                }
            });
        }
    }

    private void postLoadingFailed(final LoadingCallback<?> callback) {
        if (callback != null) {
            this.drone.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    callback.onLoadingFailed();
                }
            });
        }
    }

    private <T> void postLoadingComplete(final T loaded, final LoadingCallback<T> callback) {
        if (callback != null) {
            this.drone.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    callback.onLoadingComplete(loaded);
                }
            });
        }
    }

    public void saveMission(Mission mission, Uri saveUri, AbstractCommandListener listener) {
        if (mission == null) {
            throw new NullPointerException("Mission must be non null.");
        }
        if (saveUri == null) {
            throw new NullPointerException("Mission destination uri must be non null.");
        }
        Bundle params = new Bundle();
        params.putParcelable("extra_mission", (Parcelable)mission);
        params.putParcelable("extra_save_mission_uri", (Parcelable)saveUri);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.SAVE_MISSION", params), listener);
    }

    private Action buildComplexMissionItem(Bundle itemBundle) {
        Action payload = new Action("com.o3dr.services.android.action.BUILD_COMPLEX_MISSION_ITEM", itemBundle);
        boolean result = this.drone.performAction(payload);
        if (result) {
            return payload;
        }
        return null;
    }

    public <T extends MissionItem> T buildMissionItem(MissionItem.ComplexItem<T> complexItem) {
        MissionItem missionItem = (MissionItem)((Object)complexItem);
        Bundle payload = missionItem.getType().storeMissionItem(missionItem);
        if (payload == null) {
            return null;
        }
        Action result = this.buildComplexMissionItem(payload);
        if (result != null) {
            Object updatedItem = MissionItemType.restoreMissionItemFromBundle(result.getData());
            complexItem.copy(updatedItem);
            return (T)((MissionItem)((Object)complexItem));
        }
        return null;
    }

    public void pauseMission(AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putFloat("extra_mission_speed", 0.0f);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.CHANGE_MISSION_SPEED", params), listener);
    }

    public void setMissionSpeed(float speed, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putFloat("extra_mission_speed", speed);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.CHANGE_MISSION_SPEED", params), listener);
    }

    public static interface LoadingCallback<T> {
        public void onLoadingStart();

        public void onLoadingComplete(T var1);

        public void onLoadingFailed();
    }
}

