/*
 * Decompiled with CFR 0.152.
 */
package com.MAVLink.Messages;

import java.nio.ByteBuffer;

public class MAVLinkPayload {
    private static final byte UNSIGNED_BYTE_MIN_VALUE = 0;
    private static final short UNSIGNED_BYTE_MAX_VALUE = 255;
    private static final short UNSIGNED_SHORT_MIN_VALUE = 0;
    private static final int UNSIGNED_SHORT_MAX_VALUE = 65535;
    private static final int UNSIGNED_INT_MIN_VALUE = 0;
    private static final long UNSIGNED_INT_MAX_VALUE = 0xFFFFFFFFL;
    private static final long UNSIGNED_LONG_MIN_VALUE = 0L;
    public final ByteBuffer payload;
    public int index;

    public MAVLinkPayload(int payloadSize) {
        this.payload = ByteBuffer.allocate(payloadSize);
    }

    public ByteBuffer getData() {
        return this.payload;
    }

    public int size() {
        return this.payload.position();
    }

    public void add(byte c) {
        this.payload.put(c);
    }

    public void resetIndex() {
        this.index = 0;
    }

    public byte getByte() {
        byte result = 0;
        result = (byte)(result | this.payload.get(this.index + 0) & 0xFF);
        ++this.index;
        return result;
    }

    public short getUnsignedByte() {
        short result = 0;
        result = (short)(result | this.payload.get(this.index + 0) & 0xFF);
        ++this.index;
        return result;
    }

    public short getShort() {
        short result = 0;
        result = (short)(result | (this.payload.get(this.index + 1) & 0xFF) << 8);
        result = (short)(result | this.payload.get(this.index + 0) & 0xFF);
        this.index += 2;
        return result;
    }

    public int getUnsignedShort() {
        int result = 0;
        result |= (this.payload.get(this.index + 1) & 0xFF) << 8;
        this.index += 2;
        return result |= this.payload.get(this.index + 0) & 0xFF;
    }

    public int getInt() {
        int result = 0;
        result |= (this.payload.get(this.index + 3) & 0xFF) << 24;
        result |= (this.payload.get(this.index + 2) & 0xFF) << 16;
        result |= (this.payload.get(this.index + 1) & 0xFF) << 8;
        this.index += 4;
        return result |= this.payload.get(this.index + 0) & 0xFF;
    }

    public long getUnsignedInt() {
        long result = 0L;
        result |= ((long)this.payload.get(this.index + 3) & 0xFFFFL) << 24;
        result |= ((long)this.payload.get(this.index + 2) & 0xFFFFL) << 16;
        result |= ((long)this.payload.get(this.index + 1) & 0xFFFFL) << 8;
        this.index += 4;
        return result |= (long)this.payload.get(this.index + 0) & 0xFFFFL;
    }

    public long getLong() {
        long result = 0L;
        result |= ((long)this.payload.get(this.index + 7) & 0xFFFFL) << 56;
        result |= ((long)this.payload.get(this.index + 6) & 0xFFFFL) << 48;
        result |= ((long)this.payload.get(this.index + 5) & 0xFFFFL) << 40;
        result |= ((long)this.payload.get(this.index + 4) & 0xFFFFL) << 32;
        result |= ((long)this.payload.get(this.index + 3) & 0xFFFFL) << 24;
        result |= ((long)this.payload.get(this.index + 2) & 0xFFFFL) << 16;
        result |= ((long)this.payload.get(this.index + 1) & 0xFFFFL) << 8;
        this.index += 8;
        return result |= (long)this.payload.get(this.index + 0) & 0xFFFFL;
    }

    public long getUnsignedLong() {
        return this.getLong();
    }

    public long getLongReverse() {
        long result = 0L;
        result |= ((long)this.payload.get(this.index + 0) & 0xFFFFL) << 56;
        result |= ((long)this.payload.get(this.index + 1) & 0xFFFFL) << 48;
        result |= ((long)this.payload.get(this.index + 2) & 0xFFFFL) << 40;
        result |= ((long)this.payload.get(this.index + 3) & 0xFFFFL) << 32;
        result |= ((long)this.payload.get(this.index + 4) & 0xFFFFL) << 24;
        result |= ((long)this.payload.get(this.index + 5) & 0xFFFFL) << 16;
        result |= ((long)this.payload.get(this.index + 6) & 0xFFFFL) << 8;
        this.index += 8;
        return result |= (long)this.payload.get(this.index + 7) & 0xFFFFL;
    }

    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    public void putByte(byte data) {
        this.add(data);
    }

    public void putUnsignedByte(short data) {
        if (data < 0 || data > 255) {
            throw new IllegalArgumentException("Value is outside of the range of an unsigned byte: " + data);
        }
        this.putByte((byte)data);
    }

    public void putShort(short data) {
        this.add((byte)(data >> 0));
        this.add((byte)(data >> 8));
    }

    public void putUnsignedShort(int data) {
        if (data < 0 || data > 65535) {
            throw new IllegalArgumentException("Value is outside of the range of an unsigned short: " + data);
        }
        this.putShort((short)data);
    }

    public void putInt(int data) {
        this.add((byte)(data >> 0));
        this.add((byte)(data >> 8));
        this.add((byte)(data >> 16));
        this.add((byte)(data >> 24));
    }

    public void putUnsignedInt(long data) {
        if (data < 0L || data > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value is outside of the range of an unsigned int: " + data);
        }
        this.putInt((int)data);
    }

    public void putLong(long data) {
        this.add((byte)(data >> 0));
        this.add((byte)(data >> 8));
        this.add((byte)(data >> 16));
        this.add((byte)(data >> 24));
        this.add((byte)(data >> 32));
        this.add((byte)(data >> 40));
        this.add((byte)(data >> 48));
        this.add((byte)(data >> 56));
    }

    public void putUnsignedLong(long data) {
        if (data < 0L) {
            throw new IllegalArgumentException("Value is outside of the range of an unsigned long: " + data);
        }
        this.putLong(data);
    }

    public void putFloat(float data) {
        this.putInt(Float.floatToIntBits(data));
    }
}

