/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.utils.file.IO;

import android.content.Context;
import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.droidplanner.services.android.impl.core.drone.profiles.ParameterMetadata;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ParameterMetadataLoader {
    private static final String PARAMETERMETADATA_PATH = "Parameters/ParameterMetaData.xml";
    private static final String METADATA_DISPLAYNAME = "DisplayName";
    private static final String METADATA_DESCRIPTION = "Description";
    private static final String METADATA_UNITS = "Units";
    private static final String METADATA_VALUES = "Values";
    private static final String METADATA_RANGE = "Range";

    public static void load(Context context, String metadataType, Map<String, ParameterMetadata> metadata) throws IOException, XmlPullParserException {
        InputStream inputStream = context.getAssets().open(PARAMETERMETADATA_PATH);
        ParameterMetadataLoader.open(inputStream, metadataType, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void open(InputStream inputStream, String metadataType, Map<String, ParameterMetadata> metadataMap) throws XmlPullParserException, IOException {
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            parser.setInput(inputStream, null);
            ParameterMetadataLoader.parseMetadata(parser, metadataType, metadataMap);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void parseMetadata(XmlPullParser parser, String metadataType, Map<String, ParameterMetadata> metadataMap) throws XmlPullParserException, IOException {
        boolean parsing = false;
        ParameterMetadata metadata = null;
        metadataMap.clear();
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if (metadataType.equals(name)) {
                        parsing = true;
                        break;
                    }
                    if (!parsing) break;
                    if (metadata == null) {
                        metadata = new ParameterMetadata();
                        metadata.setName(name);
                        break;
                    }
                    ParameterMetadataLoader.addMetaDataProperty(metadata, name, parser.nextText());
                    break;
                }
                case 3: {
                    String name = parser.getName();
                    if (metadataType.equals(name)) {
                        return;
                    }
                    if (metadata == null || !metadata.getName().equals(name)) break;
                    metadataMap.put(metadata.getName(), metadata);
                    metadata = null;
                }
            }
            eventType = parser.next();
        }
    }

    private static void addMetaDataProperty(ParameterMetadata metaData, String name, String text) {
        switch (name) {
            case "DisplayName": {
                metaData.setDisplayName(text);
                break;
            }
            case "Description": {
                metaData.setDescription(text);
                break;
            }
            case "Units": {
                metaData.setUnits(text);
                break;
            }
            case "Range": {
                metaData.setRange(text);
                break;
            }
            case "Values": {
                metaData.setValues(text);
            }
        }
    }
}

