/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.utils;

import android.util.Log;
import org.droidplanner.services.android.impl.core.model.Logger;

public class AndroidLogger
implements Logger {
    private static Logger sLogger = new AndroidLogger();

    public static Logger getLogger() {
        return sLogger;
    }

    private AndroidLogger() {
    }

    @Override
    public void logVerbose(String logTag, String verbose) {
        if (verbose != null) {
            Log.v((String)logTag, (String)verbose);
        }
    }

    @Override
    public void logDebug(String logTag, String debug) {
        if (debug != null) {
            Log.d((String)logTag, (String)debug);
        }
    }

    @Override
    public void logInfo(String logTag, String info) {
        if (info != null) {
            Log.i((String)logTag, (String)info);
        }
    }

    @Override
    public void logWarning(String logTag, String warning) {
        if (warning != null) {
            Log.w((String)logTag, (String)warning);
        }
    }

    @Override
    public void logWarning(String logTag, Exception exception) {
        if (exception != null) {
            Log.w((String)logTag, (Throwable)exception);
        }
    }

    @Override
    public void logWarning(String logTag, String warning, Exception exception) {
        if (warning != null && exception != null) {
            Log.w((String)logTag, (String)warning, (Throwable)exception);
        }
    }

    @Override
    public void logErr(String logTag, String err) {
        if (err != null) {
            Log.e((String)logTag, (String)err);
        }
    }

    @Override
    public void logErr(String logTag, Exception exception) {
        if (exception != null) {
            Log.e((String)logTag, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public void logErr(String logTag, String err, Exception exception) {
        if (err != null && exception != null) {
            Log.e((String)logTag, (String)err, (Throwable)exception);
        }
    }
}

