/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.helpers.geoTools;

import com.o3dr.services.android.lib.coordinate.LatLong;
import java.util.ArrayList;
import java.util.List;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;

public class PointTools {
    public static LatLong findFarthestPoint(ArrayList<LatLong> crosses, LatLong middle) {
        double farthestDistance = Double.NEGATIVE_INFINITY;
        LatLong farthestPoint = null;
        for (LatLong cross : crosses) {
            double distance = GeoTools.getAproximatedDistance(cross, middle);
            if (!(distance > farthestDistance)) continue;
            farthestPoint = cross;
            farthestDistance = distance;
        }
        return farthestPoint;
    }

    private static LatLong findClosestPoint(LatLong point, List<LatLong> list) {
        LatLong answer = null;
        double currentbest = Double.MAX_VALUE;
        for (LatLong pnt : list) {
            double dist1 = GeoTools.getAproximatedDistance(point, pnt);
            if (!(dist1 < currentbest)) continue;
            answer = pnt;
            currentbest = dist1;
        }
        return answer;
    }

    static int findClosestPair(LatLong point, List<LatLong> waypoints2) {
        int answer = 0;
        double currentbest = Double.MAX_VALUE;
        for (int i = 0; i < waypoints2.size(); ++i) {
            LatLong p2;
            LatLong p1;
            if (i == waypoints2.size() - 1) {
                p1 = waypoints2.get(i);
                p2 = waypoints2.get(0);
            } else {
                p1 = waypoints2.get(i);
                p2 = waypoints2.get(i + 1);
            }
            double dist = PointTools.pointToLineDistance(p1, p2, point);
            if (!(dist < currentbest)) continue;
            answer = i + 1;
            currentbest = dist;
        }
        return answer;
    }

    public static double pointToLineDistance(LatLong L1, LatLong L2, LatLong P) {
        double yy;
        double xx;
        double len_sq;
        double D;
        double A = P.getLatitude() - L1.getLatitude();
        double B = P.getLongitude() - L1.getLongitude();
        double C = L2.getLatitude() - L1.getLatitude();
        double dot = A * C + B * (D = L2.getLongitude() - L1.getLongitude());
        double param = dot / (len_sq = C * C + D * D);
        if (param < 0.0) {
            xx = L1.getLatitude();
            yy = L1.getLongitude();
        } else if (param > 1.0) {
            xx = L2.getLatitude();
            yy = L2.getLongitude();
        } else {
            xx = L1.getLatitude() + param * C;
            yy = L1.getLongitude() + param * D;
        }
        return Math.hypot(xx - P.getLatitude(), yy - P.getLongitude());
    }
}

