/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.helpers.geoTools;

import com.o3dr.services.android.lib.coordinate.LatLong;
import java.util.ArrayList;
import java.util.List;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;

public class LineSampler {
    private List<LatLong> points;
    private List<LatLong> sampledPoints = new ArrayList<LatLong>();

    public LineSampler(List<LatLong> points) {
        this.points = points;
    }

    public LineSampler(LatLong p1, LatLong p2) {
        this.points = new ArrayList<LatLong>();
        this.points.add(p1);
        this.points.add(p2);
    }

    public List<LatLong> sample(double sampleDistance) {
        for (int i = 1; i < this.points.size(); ++i) {
            LatLong from = this.points.get(i - 1);
            if (from == null) continue;
            LatLong to = this.points.get(i);
            this.sampledPoints.addAll(this.sampleLine(from, to, sampleDistance));
        }
        LatLong lastPoint = this.getLast(this.points);
        if (lastPoint != null) {
            this.sampledPoints.add(lastPoint);
        }
        return this.sampledPoints;
    }

    private List<LatLong> sampleLine(LatLong from, LatLong to, double samplingDistance) {
        ArrayList<LatLong> result = new ArrayList<LatLong>();
        double heading = GeoTools.getHeadingFromCoordinates(from, to);
        double totalLength = GeoTools.getDistance(from, to);
        for (double distance = 0.0; distance < totalLength; distance += samplingDistance) {
            result.add(GeoTools.newCoordFromBearingAndDistance(from, heading, distance));
        }
        return result;
    }

    private LatLong getLast(List<LatLong> list) {
        return list.get(list.size() - 1);
    }
}

