/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.variables;

import android.os.Handler;
import android.os.RemoteException;
import android.os.SystemClock;
import com.MAVLink.ardupilotmega.msg_ekf_status_report;
import com.o3dr.services.android.lib.model.ICommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import org.droidplanner.services.android.impl.core.MAVLink.MavLinkCommands;
import org.droidplanner.services.android.impl.core.MAVLink.WaypointManager;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneVariable;
import org.droidplanner.services.android.impl.core.drone.autopilot.generic.GenericMavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.variables.ApmModes;
import org.droidplanner.services.android.impl.core.model.AutopilotWarningParser;
import timber.log.Timber;

public class State
extends DroneVariable<GenericMavLinkDrone> {
    private static final long ERROR_TIMEOUT = 5000L;
    private static final Action requestHomeUpdateAction = new Action("org.droidplanner.services.android.core.drone.autopilot.action.REQUEST_HOME_UPDATE");
    private final AutopilotWarningParser warningParser;
    private msg_ekf_status_report ekfStatus;
    private boolean isEkfPositionOk;
    private String errorId;
    private boolean armed = false;
    private boolean isFlying = false;
    private ApmModes mode = ApmModes.UNKNOWN;
    private long startTime = 0L;
    private final Handler handler;
    private final Runnable watchdogCallback = new Runnable(){

        @Override
        public void run() {
            State.this.resetWarning();
        }
    };

    public State(GenericMavLinkDrone myDrone, Handler handler, AutopilotWarningParser warningParser) {
        super(myDrone);
        this.handler = handler;
        this.warningParser = warningParser;
        this.errorId = warningParser.getDefaultWarning();
        this.resetFlightStartTime();
    }

    public boolean isArmed() {
        return this.armed;
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public ApmModes getMode() {
        return this.mode;
    }

    public String getErrorId() {
        return this.errorId;
    }

    public void setIsFlying(boolean newState) {
        if (newState != this.isFlying) {
            this.isFlying = newState;
            ((GenericMavLinkDrone)this.myDrone).notifyDroneEvent(DroneInterfaces.DroneEventsType.STATE);
            if (this.isFlying) {
                this.resetFlightStartTime();
            }
        }
    }

    public boolean parseAutopilotError(String errorMsg) {
        String parsedError = this.warningParser.parseWarning(this.myDrone, errorMsg);
        if (parsedError == null || parsedError.trim().isEmpty()) {
            return false;
        }
        if (!parsedError.equals(this.errorId)) {
            this.errorId = parsedError;
            ((GenericMavLinkDrone)this.myDrone).notifyDroneEvent(DroneInterfaces.DroneEventsType.AUTOPILOT_WARNING);
        }
        this.handler.removeCallbacks(this.watchdogCallback);
        this.handler.postDelayed(this.watchdogCallback, 5000L);
        return true;
    }

    public void repeatWarning() {
        if (this.errorId == null || this.errorId.length() == 0 || this.errorId.equals(this.warningParser.getDefaultWarning())) {
            return;
        }
        this.handler.removeCallbacks(this.watchdogCallback);
        this.handler.postDelayed(this.watchdogCallback, 5000L);
    }

    public void setArmed(boolean newState) {
        if (this.armed != newState) {
            WaypointManager waypointManager;
            this.armed = newState;
            ((GenericMavLinkDrone)this.myDrone).notifyDroneEvent(DroneInterfaces.DroneEventsType.ARMING);
            if (newState && (waypointManager = ((GenericMavLinkDrone)this.myDrone).getWaypointManager()) != null) {
                waypointManager.getWaypoints();
            }
        }
        this.checkEkfPositionState(this.ekfStatus);
    }

    public void setMode(ApmModes mode) {
        if (this.mode != mode) {
            this.mode = mode;
            ((GenericMavLinkDrone)this.myDrone).notifyDroneEvent(DroneInterfaces.DroneEventsType.MODE);
        }
    }

    public void changeFlightMode(ApmModes mode, final ICommandListener listener) {
        if (this.mode == mode) {
            if (listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            listener.onSuccess();
                        }
                        catch (RemoteException e) {
                            Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                        }
                    }
                });
            }
            return;
        }
        if (ApmModes.isValid(mode)) {
            MavLinkCommands.changeFlightMode(this.myDrone, mode, listener);
        } else if (listener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onError(4);
                    }
                    catch (RemoteException e) {
                        Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    private void resetWarning() {
        String defaultWarning = this.warningParser.getDefaultWarning();
        if (defaultWarning == null) {
            defaultWarning = "";
        }
        if (!defaultWarning.equals(this.errorId)) {
            this.errorId = defaultWarning;
            ((GenericMavLinkDrone)this.myDrone).notifyDroneEvent(DroneInterfaces.DroneEventsType.AUTOPILOT_WARNING);
        }
    }

    private void resetFlightStartTime() {
        this.startTime = SystemClock.elapsedRealtime();
    }

    public long getFlightStartTime() {
        return this.startTime;
    }

    public msg_ekf_status_report getEkfStatus() {
        return this.ekfStatus;
    }

    public void setEkfStatus(msg_ekf_status_report ekfState) {
        if (this.ekfStatus == null || !State.areEkfStatusEquals(this.ekfStatus, ekfState)) {
            this.ekfStatus = ekfState;
            ((GenericMavLinkDrone)this.myDrone).notifyDroneEvent(DroneInterfaces.DroneEventsType.EKF_STATUS_UPDATE);
        }
    }

    private void checkEkfPositionState(msg_ekf_status_report ekfStatus) {
        boolean isOk;
        if (ekfStatus == null) {
            return;
        }
        int flags = ekfStatus.flags;
        boolean bl = this.armed ? (flags & 0x10) != 0 && (flags & 0x80) == 0 : (isOk = (flags & 0x10) != 0 || (flags & 0x200) != 0);
        if (this.isEkfPositionOk != isOk) {
            this.isEkfPositionOk = isOk;
            ((GenericMavLinkDrone)this.myDrone).notifyDroneEvent(DroneInterfaces.DroneEventsType.EKF_POSITION_STATE_UPDATE);
            if (this.isEkfPositionOk) {
                ((GenericMavLinkDrone)this.myDrone).executeAsyncAction(requestHomeUpdateAction, null);
            }
        }
    }

    private static boolean areEkfStatusEquals(msg_ekf_status_report one, msg_ekf_status_report two) {
        return one == two || one != null && two != null && one.toString().equals(two.toString());
    }

    public boolean isEkfPositionOk() {
        return this.isEkfPositionOk;
    }
}

