/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.variables;

import com.MAVLink.common.msg_raw_imu;
import com.o3dr.services.android.lib.drone.property.Parameter;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneVariable;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;

public class Magnetometer
extends DroneVariable {
    private int x;
    private int y;
    private int z;

    public Magnetometer(MavLinkDrone myDrone) {
        super(myDrone);
    }

    public void newData(msg_raw_imu msg_imu) {
        this.x = msg_imu.xmag;
        this.y = msg_imu.ymag;
        this.z = msg_imu.zmag;
        this.myDrone.notifyDroneEvent(DroneInterfaces.DroneEventsType.MAGNETOMETER);
    }

    public int[] getVector() {
        return new int[]{this.x, this.y, this.z};
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int[] getOffsets() {
        Parameter paramX = this.myDrone.getParameterManager().getParameter("COMPASS_OFS_X");
        Parameter paramY = this.myDrone.getParameterManager().getParameter("COMPASS_OFS_Y");
        Parameter paramZ = this.myDrone.getParameterManager().getParameter("COMPASS_OFS_Z");
        if (paramX == null || paramY == null || paramZ == null) {
            return null;
        }
        return new int[]{(int)paramX.getValue(), (int)paramY.getValue(), (int)paramZ.getValue()};
    }
}

