/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.variables;

import android.os.Handler;
import android.os.RemoteException;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.drone.property.Altitude;
import com.o3dr.services.android.lib.drone.property.Gps;
import com.o3dr.services.android.lib.model.ICommandListener;
import com.o3dr.services.android.lib.model.SimpleCommandListener;
import org.droidplanner.services.android.impl.core.MAVLink.MavLinkCommands;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneVariable;
import org.droidplanner.services.android.impl.core.drone.autopilot.Drone;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.variables.ApmModes;
import org.droidplanner.services.android.impl.core.drone.variables.State;
import org.droidplanner.services.android.impl.core.drone.variables.Type;
import timber.log.Timber;

public class GuidedPoint
extends DroneVariable
implements DroneInterfaces.OnDroneListener<MavLinkDrone> {
    private GuidedStates state = GuidedStates.UNINITIALIZED;
    private LatLong coord = new LatLong(0.0, 0.0);
    private double altitude = 0.0;
    private Runnable mPostInitializationTask;
    private final Handler handler;

    public GuidedPoint(MavLinkDrone myDrone, Handler handler) {
        super(myDrone);
        this.handler = handler;
        myDrone.addDroneListener(this);
    }

    @Override
    public void onDroneEvent(DroneInterfaces.DroneEventsType event, MavLinkDrone drone) {
        switch (event) {
            case HEARTBEAT_FIRST: 
            case HEARTBEAT_RESTORED: 
            case MODE: {
                if (GuidedPoint.isGuidedMode(this.myDrone)) {
                    this.initialize();
                    break;
                }
                this.disable();
                break;
            }
            case DISCONNECTED: 
            case HEARTBEAT_TIMEOUT: {
                this.disable();
            }
        }
    }

    public static boolean isGuidedMode(MavLinkDrone drone) {
        if (drone == null) {
            return false;
        }
        int droneType = drone.getType();
        ApmModes droneMode = drone.getState().getMode();
        if (Type.isCopter(droneType)) {
            return droneMode == ApmModes.ROTOR_GUIDED;
        }
        if (Type.isPlane(droneType)) {
            return droneMode == ApmModes.FIXED_WING_GUIDED;
        }
        if (Type.isRover(droneType)) {
            return droneMode == ApmModes.ROVER_GUIDED || droneMode == ApmModes.ROVER_HOLD;
        }
        return false;
    }

    public void pauseAtCurrentLocation(ICommandListener listener) {
        if (this.state == GuidedStates.UNINITIALIZED) {
            GuidedPoint.changeToGuidedMode(this.myDrone, listener);
        } else {
            this.newGuidedCoord(this.getGpsPosition());
            this.state = GuidedStates.IDLE;
        }
    }

    private LatLong getGpsPosition() {
        return GuidedPoint.getGpsPosition(this.myDrone);
    }

    private static LatLong getGpsPosition(Drone drone) {
        Gps droneGps = (Gps)drone.getAttribute("com.o3dr.services.android.lib.attribute.GPS");
        return droneGps == null ? null : droneGps.getPosition();
    }

    public static void changeToGuidedMode(MavLinkDrone drone, ICommandListener listener) {
        State droneState = drone.getState();
        int droneType = drone.getType();
        if (Type.isCopter(droneType)) {
            droneState.changeFlightMode(ApmModes.ROTOR_GUIDED, listener);
        } else if (Type.isPlane(droneType)) {
            GuidedPoint.forceSendGuidedPoint(drone, GuidedPoint.getGpsPosition(drone), GuidedPoint.getDroneAltConstrained(drone));
        } else if (Type.isRover(droneType)) {
            droneState.changeFlightMode(ApmModes.ROVER_GUIDED, listener);
        }
    }

    public void doGuidedTakeoff(final double alt, final ICommandListener listener) {
        if (Type.isCopter(this.myDrone.getType())) {
            this.coord = this.getGpsPosition();
            this.altitude = alt;
            this.state = GuidedStates.IDLE;
            GuidedPoint.changeToGuidedMode(this.myDrone, new SimpleCommandListener(){

                @Override
                public void onSuccess() {
                    MavLinkCommands.sendTakeoff(GuidedPoint.this.myDrone, alt, listener);
                    GuidedPoint.this.myDrone.notifyDroneEvent(DroneInterfaces.DroneEventsType.GUIDEDPOINT);
                }

                @Override
                public void onError(int executionError) {
                    if (listener != null) {
                        try {
                            listener.onError(executionError);
                        }
                        catch (RemoteException e) {
                            Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                        }
                    }
                }

                @Override
                public void onTimeout() {
                    if (listener != null) {
                        try {
                            listener.onTimeout();
                        }
                        catch (RemoteException e) {
                            Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                        }
                    }
                }
            });
        } else if (listener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onError(3);
                    }
                    catch (RemoteException e) {
                        Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    public void newGuidedCoord(LatLong coord) {
        this.changeCoord(coord);
    }

    public void newGuidedPosition(double latitude, double longitude, double altitude) {
        MavLinkCommands.sendGuidedPosition(this.myDrone, latitude, longitude, altitude);
    }

    public void newGuidedVelocity(double xVel, double yVel, double zVel) {
        MavLinkCommands.sendGuidedVelocity(this.myDrone, xVel, yVel, zVel);
    }

    public void newGuidedCoordAndVelocity(LatLong coord, double xVel, double yVel, double zVel) {
        this.changeCoordAndVelocity(coord, xVel, yVel, zVel);
    }

    public void changeGuidedAltitude(double alt) {
        this.changeAlt(alt);
    }

    public void forcedGuidedCoordinate(final LatLong coord, ICommandListener listener) {
        Gps droneGps = (Gps)this.myDrone.getAttribute("com.o3dr.services.android.lib.attribute.GPS");
        if (!droneGps.has3DLock()) {
            this.postErrorEvent(this.handler, listener, 4);
            return;
        }
        if (this.isInitialized()) {
            this.changeCoord(coord);
            this.postSuccessEvent(this.handler, listener);
        } else {
            this.mPostInitializationTask = new Runnable(){

                @Override
                public void run() {
                    GuidedPoint.this.changeCoord(coord);
                }
            };
            GuidedPoint.changeToGuidedMode(this.myDrone, listener);
        }
    }

    public void forcedGuidedCoordinate(final LatLong coord, final double alt, ICommandListener listener) {
        Gps droneGps = (Gps)this.myDrone.getAttribute("com.o3dr.services.android.lib.attribute.GPS");
        if (!droneGps.has3DLock()) {
            this.postErrorEvent(this.handler, listener, 4);
            return;
        }
        if (this.isInitialized()) {
            this.changeCoord(coord);
            this.changeAlt(alt);
            this.postSuccessEvent(this.handler, listener);
        } else {
            this.mPostInitializationTask = new Runnable(){

                @Override
                public void run() {
                    GuidedPoint.this.changeCoord(coord);
                    GuidedPoint.this.changeAlt(alt);
                }
            };
            GuidedPoint.changeToGuidedMode(this.myDrone, listener);
        }
    }

    private void initialize() {
        if (this.state == GuidedStates.UNINITIALIZED) {
            this.coord = this.getGpsPosition();
            this.altitude = GuidedPoint.getDroneAltConstrained(this.myDrone);
            this.state = GuidedStates.IDLE;
            this.myDrone.notifyDroneEvent(DroneInterfaces.DroneEventsType.GUIDEDPOINT);
        }
        if (this.mPostInitializationTask != null) {
            this.mPostInitializationTask.run();
            this.mPostInitializationTask = null;
        }
    }

    private void disable() {
        if (this.state == GuidedStates.UNINITIALIZED) {
            return;
        }
        this.state = GuidedStates.UNINITIALIZED;
        this.myDrone.notifyDroneEvent(DroneInterfaces.DroneEventsType.GUIDEDPOINT);
    }

    private void changeAlt(double alt) {
        switch (this.state) {
            case UNINITIALIZED: {
                break;
            }
            case IDLE: {
                this.state = GuidedStates.ACTIVE;
            }
            case ACTIVE: {
                this.altitude = alt;
                this.sendGuidedPoint();
            }
        }
    }

    private void changeCoord(LatLong coord) {
        switch (this.state) {
            case UNINITIALIZED: {
                break;
            }
            case IDLE: {
                this.state = GuidedStates.ACTIVE;
            }
            case ACTIVE: {
                this.coord = coord;
                this.sendGuidedPoint();
            }
        }
    }

    private void changeCoordAndVelocity(LatLong coord, double xVel, double yVel, double zVel) {
        switch (this.state) {
            case UNINITIALIZED: {
                break;
            }
            case IDLE: {
                this.state = GuidedStates.ACTIVE;
            }
            case ACTIVE: {
                this.coord = coord;
                this.sendGuidedPointAndVelocity(xVel, yVel, zVel);
            }
        }
    }

    private void sendGuidedPointAndVelocity(double xVel, double yVel, double zVel) {
        if (this.state == GuidedStates.ACTIVE) {
            GuidedPoint.forceSendGuidedPointAndVelocity(this.myDrone, this.coord, this.altitude, xVel, yVel, zVel);
        }
    }

    private void sendGuidedPoint() {
        if (this.state == GuidedStates.ACTIVE) {
            GuidedPoint.forceSendGuidedPoint(this.myDrone, this.coord, this.altitude);
        }
    }

    public static void forceSendGuidedPoint(MavLinkDrone drone, LatLong coord, double altitudeInMeters) {
        drone.notifyDroneEvent(DroneInterfaces.DroneEventsType.GUIDEDPOINT);
        if (coord != null) {
            MavLinkCommands.setGuidedMode(drone, coord.getLatitude(), coord.getLongitude(), altitudeInMeters);
        }
    }

    public static void forceSendGuidedPointAndVelocity(MavLinkDrone drone, LatLong coord, double altitudeInMeters, double xVel, double yVel, double zVel) {
        drone.notifyDroneEvent(DroneInterfaces.DroneEventsType.GUIDEDPOINT);
        if (coord != null) {
            MavLinkCommands.sendGuidedPositionAndVelocity(drone, coord.getLatitude(), coord.getLongitude(), altitudeInMeters, xVel, yVel, zVel);
        }
    }

    private static double getDroneAltConstrained(MavLinkDrone drone) {
        Altitude droneAltitude = (Altitude)drone.getAttribute("com.o3dr.services.android.lib.attribute.ALTITUDE");
        double alt = Math.floor(droneAltitude.getAltitude());
        return Math.max(alt, (double)GuidedPoint.getDefaultMinAltitude(drone));
    }

    public LatLong getCoord() {
        return this.coord;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public boolean isActive() {
        return this.state == GuidedStates.ACTIVE;
    }

    public boolean isIdle() {
        return this.state == GuidedStates.IDLE;
    }

    public boolean isInitialized() {
        return this.state != GuidedStates.UNINITIALIZED;
    }

    public GuidedStates getState() {
        return this.state;
    }

    public static float getDefaultMinAltitude(MavLinkDrone drone) {
        int droneType = drone.getType();
        if (Type.isCopter(droneType)) {
            return 2.0f;
        }
        if (Type.isPlane(droneType)) {
            return 15.0f;
        }
        return 0.0f;
    }

    public static enum GuidedStates {
        UNINITIALIZED,
        IDLE,
        ACTIVE;

    }
}

