/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.manager;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import com.MAVLink.MAVLinkPacket;
import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.ardupilotmega.msg_mag_cal_progress;
import com.MAVLink.ardupilotmega.msg_mag_cal_report;
import com.MAVLink.common.msg_command_ack;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.drone.connection.ConnectionParameter;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import com.o3dr.services.android.lib.gcs.follow.FollowLocationSource;
import com.o3dr.services.android.lib.gcs.follow.FollowType;
import com.o3dr.services.android.lib.gcs.link.LinkConnectionStatus;
import com.o3dr.services.android.lib.gcs.returnToMe.ReturnToMeState;
import com.o3dr.services.android.lib.model.ICommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.droidplanner.services.android.impl.api.DroneApi;
import org.droidplanner.services.android.impl.communication.service.MAVLinkClient;
import org.droidplanner.services.android.impl.core.MAVLink.MavLinkMsgHandler;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneManager;
import org.droidplanner.services.android.impl.core.drone.LogMessageListener;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.ArduCopter;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.ArduPlane;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.ArduRover;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.ArduSolo;
import org.droidplanner.services.android.impl.core.drone.autopilot.generic.GenericMavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.autopilot.px4.Px4Native;
import org.droidplanner.services.android.impl.core.drone.manager.DroneCommandTracker;
import org.droidplanner.services.android.impl.core.drone.profiles.ParameterManager;
import org.droidplanner.services.android.impl.core.drone.variables.StreamRates;
import org.droidplanner.services.android.impl.core.drone.variables.calibration.MagnetometerCalibrationImpl;
import org.droidplanner.services.android.impl.core.firmware.FirmwareType;
import org.droidplanner.services.android.impl.core.gcs.GCSHeartbeat;
import org.droidplanner.services.android.impl.core.gcs.ReturnToMe;
import org.droidplanner.services.android.impl.core.gcs.follow.Follow;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowAlgorithm;
import org.droidplanner.services.android.impl.core.gcs.location.FusedLocation;
import org.droidplanner.services.android.impl.core.model.AutopilotWarningParser;
import org.droidplanner.services.android.impl.utils.AndroidApWarningParser;
import org.droidplanner.services.android.impl.utils.CommonApiUtils;
import org.droidplanner.services.android.impl.utils.SoloApiUtils;
import timber.log.Timber;

public class MavLinkDroneManager
extends DroneManager<MavLinkDrone, MAVLinkPacket>
implements MagnetometerCalibrationImpl.OnMagnetometerCalibrationListener {
    private static final int DEFAULT_STREAM_RATE = 2;
    private Follow followMe;
    private ReturnToMe returnToMe;
    private final MAVLinkClient mavClient;
    private final MavLinkMsgHandler mavLinkMsgHandler;
    private final DroneCommandTracker commandTracker;
    private final GCSHeartbeat gcsHeartbeat;
    private AtomicInteger droneStreamRate = new AtomicInteger(2);

    public MavLinkDroneManager(Context context, ConnectionParameter connParams, Handler handler) {
        super(context, connParams, handler);
        this.commandTracker = new DroneCommandTracker(handler);
        this.mavClient = new MAVLinkClient(context, this, connParams, this.commandTracker);
        this.gcsHeartbeat = new GCSHeartbeat(this.mavClient, 1);
        this.mavLinkMsgHandler = new MavLinkMsgHandler(this);
        this.updateDroneStreamRate(connParams);
    }

    public void onVehicleTypeReceived(FirmwareType type) {
        MagnetometerCalibrationImpl magnetometer;
        if (this.drone != null) {
            return;
        }
        String droneId = this.connectionParameter.getUniqueId() + ":" + type.getType();
        switch (type) {
            case ARDU_COPTER: {
                if (this.isCompanionComputerEnabled()) {
                    this.onVehicleTypeReceived(FirmwareType.ARDU_SOLO);
                    return;
                }
                Timber.i((String)"Instantiating ArduCopter autopilot.", (Object[])new Object[0]);
                this.drone = new ArduCopter(droneId, this.context, this.mavClient, this.handler, (AutopilotWarningParser)new AndroidApWarningParser(), (LogMessageListener)this);
                break;
            }
            case ARDU_SOLO: {
                Timber.i((String)"Instantiating ArduSolo autopilot.", (Object[])new Object[0]);
                this.drone = new ArduSolo(droneId, this.context, this.mavClient, this.handler, (AutopilotWarningParser)new AndroidApWarningParser(), (LogMessageListener)this);
                break;
            }
            case ARDU_PLANE: {
                Timber.i((String)"Instantiating ArduPlane autopilot.", (Object[])new Object[0]);
                this.drone = new ArduPlane(droneId, this.context, this.mavClient, this.handler, (AutopilotWarningParser)new AndroidApWarningParser(), (LogMessageListener)this);
                break;
            }
            case ARDU_ROVER: {
                Timber.i((String)"Instantiating ArduPlane autopilot.", (Object[])new Object[0]);
                this.drone = new ArduRover(droneId, this.context, this.mavClient, this.handler, (AutopilotWarningParser)new AndroidApWarningParser(), (LogMessageListener)this);
                break;
            }
            case PX4_NATIVE: {
                Timber.i((String)"Instantiating PX4 Native autopilot.", (Object[])new Object[0]);
                this.drone = new Px4Native(droneId, this.context, this.handler, this.mavClient, new AndroidApWarningParser(), this);
                break;
            }
            case GENERIC: {
                Timber.i((String)"Instantiating Generic mavlink autopilot.", (Object[])new Object[0]);
                this.drone = new GenericMavLinkDrone(droneId, this.context, this.handler, this.mavClient, new AndroidApWarningParser(), this);
            }
        }
        this.followMe = new Follow(this, this.handler, new FusedLocation(this.context, this.handler));
        this.returnToMe = new ReturnToMe(this, new FusedLocation(this.context, this.handler, 100, 1000L, 1000L, 5.0f), this);
        StreamRates streamRates = ((MavLinkDrone)this.drone).getStreamRates();
        if (streamRates != null) {
            streamRates.setRates(new StreamRates.Rates(this.droneStreamRate.get()));
        }
        ((MavLinkDrone)this.drone).addDroneListener(this);
        ((MavLinkDrone)this.drone).setAttributeListener(this);
        ParameterManager parameterManager = ((MavLinkDrone)this.drone).getParameterManager();
        if (parameterManager != null) {
            parameterManager.setParameterListener(this);
        }
        if ((magnetometer = ((MavLinkDrone)this.drone).getMagnetometerCalibration()) != null) {
            magnetometer.setListener(this);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.followMe != null && this.followMe.isEnabled()) {
            this.followMe.disableFollowMe();
        }
        if (this.returnToMe != null) {
            this.returnToMe.disable();
        }
    }

    @Override
    protected void doConnect(String appId, DroneApi listener, ConnectionParameter connParams) {
        if (this.mavClient.isDisconnected()) {
            Timber.i((String)"Opening connection for %s", (Object[])new Object[]{appId});
            this.mavClient.openConnection();
        } else if (this.isConnected()) {
            listener.onDroneEvent(DroneInterfaces.DroneEventsType.CONNECTED, this.drone);
            if (!((MavLinkDrone)this.drone).isConnectionAlive()) {
                listener.onDroneEvent(DroneInterfaces.DroneEventsType.HEARTBEAT_TIMEOUT, this.drone);
            }
        }
        this.mavClient.registerForTLogLogging(appId, connParams.getTLogLoggingUri());
        this.updateDroneStreamRate(connParams);
    }

    private void updateDroneStreamRate(ConnectionParameter connParams) {
        boolean updateComplete;
        long eventsDispatchingPeriod = connParams.getEventsDispatchingPeriod();
        if (eventsDispatchingPeriod <= 0L) {
            return;
        }
        int eventsDispatchingRate = Math.round(1000L / eventsDispatchingPeriod);
        do {
            StreamRates rates;
            updateComplete = true;
            int currentRate = this.droneStreamRate.get();
            if (eventsDispatchingRate <= currentRate || !(updateComplete = this.droneStreamRate.compareAndSet(currentRate, eventsDispatchingRate)) || this.drone == null || (rates = ((MavLinkDrone)this.drone).getStreamRates()) == null) continue;
            rates.setRates(new StreamRates.Rates(this.droneStreamRate.get()));
        } while (!updateComplete);
    }

    @Override
    protected void doDisconnect(String appId, DroneApi listener) {
        if (this.drone instanceof GenericMavLinkDrone) {
            ((GenericMavLinkDrone)this.drone).tryStoppingVideoStream(appId);
        }
        if (listener != null) {
            this.mavClient.unregisterForTLogLogging(appId);
            if (this.isConnected()) {
                listener.onDroneEvent(DroneInterfaces.DroneEventsType.DISCONNECTED, this.drone);
            }
        }
        if (this.mavClient.isConnected() && this.connectedApps.isEmpty()) {
            this.executeAsyncAction(new Action("com.o3dr.services.android.action.gimbal.RESET_GIMBAL_MOUNT_MODE"), null);
            this.mavClient.closeConnection();
        }
    }

    private void handleCommandAck(msg_command_ack ack) {
        if (ack != null) {
            this.commandTracker.onCommandAck(77, ack);
        }
    }

    @Override
    public void notifyReceivedData(MAVLinkPacket packet) {
        MAVLinkMessage receivedMsg = packet.unpack();
        if (receivedMsg == null) {
            return;
        }
        if (receivedMsg.msgid == 77) {
            msg_command_ack commandAck = (msg_command_ack)receivedMsg;
            this.handleCommandAck(commandAck);
        } else {
            this.mavLinkMsgHandler.receiveData(receivedMsg);
            if (this.drone != null) {
                ((MavLinkDrone)this.drone).onMavLinkMessageReceived(receivedMsg);
            }
        }
        if (!this.connectedApps.isEmpty()) {
            for (DroneApi droneEventsListener : this.connectedApps.values()) {
                droneEventsListener.onReceivedMavLinkMessage(receivedMsg);
            }
        }
    }

    @Override
    public void onConnectionStatus(LinkConnectionStatus connectionStatus) {
        super.onConnectionStatus(connectionStatus);
        switch (connectionStatus.getStatusCode()) {
            case "DISCONNECTED": {
                this.gcsHeartbeat.setActive(false);
                break;
            }
            case "CONNECTED": {
                this.gcsHeartbeat.setActive(true);
            }
        }
    }

    @Override
    public DroneAttribute getAttribute(DroneApi.ClientInfo clientInfo, String attributeType) {
        switch (attributeType) {
            case "com.o3dr.services.android.lib.attribute.FOLLOW_STATE": {
                return CommonApiUtils.getFollowState(this.followMe);
            }
            case "com.o3dr.services.android.lib.attribute.RETURN_TO_ME_STATE": {
                return this.returnToMe == null ? new ReturnToMeState() : this.returnToMe.getState();
            }
        }
        return super.getAttribute(clientInfo, attributeType);
    }

    @Override
    protected boolean executeAsyncAction(Action action, ICommandListener listener) {
        String type = action.getType();
        Bundle data = action.getData();
        Timber.d((String)"executeAsyncAction(): action=%s", (Object[])new Object[]{type});
        switch (type) {
            case "com.o3dr.services.android.action.ENABLE_FOLLOW_ME": {
                data.setClassLoader(FollowType.class.getClassLoader());
                FollowLocationSource locationSource = (FollowLocationSource)data.getParcelable("extra_location_source");
                if (locationSource == null) {
                    locationSource = FollowLocationSource.INTERNAL;
                }
                FollowType followType = (FollowType)data.getParcelable("extra_follow_type");
                this.enableFollowMe(followType, locationSource, listener);
                return true;
            }
            case "com.o3dr.services.android.action.UPDATE_FOLLOW_PARAMS": {
                if (this.followMe != null) {
                    data.setClassLoader(LatLong.class.getClassLoader());
                    FollowAlgorithm followAlgorithm = this.followMe.getFollowAlgorithm();
                    if (followAlgorithm != null) {
                        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                        Set dataKeys = data.keySet();
                        for (String key : dataKeys) {
                            paramsMap.put(key, data.get(key));
                        }
                        followAlgorithm.updateAlgorithmParams(paramsMap);
                    }
                }
                return true;
            }
            case "com.o3dr.services.android.action.DISABLE_FOLLOW_ME": {
                CommonApiUtils.disableFollowMe(this.followMe);
                return true;
            }
            case "com.o3dr.services.android.action.NEW_EXTERNAL_LOCATION": {
                Location loc;
                data.setClassLoader(Location.class.getClassLoader());
                if (this.followMe != null && data != null && (loc = (Location)data.getParcelable("extra_location")) != null) {
                    Timber.i((String)"onNewLocation(%s)", (Object[])new Object[]{loc});
                    this.followMe.onFollowNewLocation(loc);
                }
                return true;
            }
            case "com.o3dr.services.android.action.ENABLE_RETURN_TO_ME": {
                boolean isEnabled = data.getBoolean("extra_is_return_to_me_enabled", false);
                if (this.returnToMe != null) {
                    if (isEnabled) {
                        this.returnToMe.enable(listener);
                    } else {
                        this.returnToMe.disable();
                    }
                    CommonApiUtils.postSuccessEvent(listener);
                } else {
                    CommonApiUtils.postErrorEvent(4, listener);
                }
                return true;
            }
        }
        return super.executeAsyncAction(action, listener);
    }

    private void enableFollowMe(FollowType followType, FollowLocationSource source, ICommandListener listener) {
        Timber.d((String)"enableFollowMe(): followType=%s source=%s", (Object[])new Object[]{followType, source});
        FollowAlgorithm.FollowModes selectedMode = CommonApiUtils.followTypeToMode((MavLinkDrone)this.drone, followType);
        if (selectedMode != null) {
            if (this.followMe == null) {
                Timber.d((String)"enableFollowMe(): followMe is null", (Object[])new Object[0]);
                return;
            }
            Timber.d((String)"CURRENT: followMe.enabled=%s followMe.state=%s source=%s", (Object[])new Object[]{this.followMe.isEnabled(), this.followMe.getState(), source});
            this.followMe.enableFollowMe(source);
            FollowAlgorithm currentAlg = this.followMe.getFollowAlgorithm();
            if (currentAlg.getType() != selectedMode) {
                if (selectedMode == FollowAlgorithm.FollowModes.SOLO_SHOT && !SoloApiUtils.isSoloLinkFeatureAvailable(this.drone, listener)) {
                    Timber.w((String)"FollowType is SOLO_SHOT, but SoloLink is not available.", (Object[])new Object[0]);
                    return;
                }
                FollowAlgorithm algo = selectedMode.getAlgorithmType(this, this.handler);
                Timber.d((String)"Setting followAlgorithm to %s", (Object[])new Object[]{algo});
                this.followMe.setAlgorithm(algo);
                CommonApiUtils.postSuccessEvent(listener);
            }
            Timber.i((String)"AFTER: followMe.state=%s type=%s", (Object[])new Object[]{this.followMe.getState(), followType});
        }
    }

    @Override
    public void onCalibrationCancelled() {
        if (this.connectedApps.isEmpty()) {
            return;
        }
        for (DroneApi listener : this.connectedApps.values()) {
            listener.onCalibrationCancelled();
        }
    }

    @Override
    public void onCalibrationProgress(msg_mag_cal_progress progress) {
        if (this.connectedApps.isEmpty()) {
            return;
        }
        for (DroneApi listener : this.connectedApps.values()) {
            listener.onCalibrationProgress(progress);
        }
    }

    @Override
    public void onCalibrationCompleted(msg_mag_cal_report report) {
        if (this.connectedApps.isEmpty()) {
            return;
        }
        for (DroneApi listener : this.connectedApps.values()) {
            listener.onCalibrationCompleted(report);
        }
    }
}

