/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.o3dr.services.android.lib.drone.connection.ConnectionParameter;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import com.o3dr.services.android.lib.drone.property.Parameter;
import com.o3dr.services.android.lib.gcs.link.LinkConnectionStatus;
import com.o3dr.services.android.lib.model.ICommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.concurrent.ConcurrentHashMap;
import org.droidplanner.services.android.impl.api.DroneApi;
import org.droidplanner.services.android.impl.communication.model.DataLink;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.LogMessageListener;
import org.droidplanner.services.android.impl.core.drone.autopilot.Drone;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.ArduSolo;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.SoloComp;
import org.droidplanner.services.android.impl.core.drone.manager.MavLinkDroneManager;
import org.droidplanner.services.android.impl.utils.CommonApiUtils;

public class DroneManager<T extends Drone, D>
implements DataLink.DataLinkListener<D>,
DroneInterfaces.OnDroneListener,
DroneInterfaces.OnParameterManagerListener,
LogMessageListener,
DroneInterfaces.AttributeEventListener {
    private static final String TAG = DroneManager.class.getSimpleName();
    public static final String EXTRA_CLIENT_APP_ID = "extra_client_app_id";
    protected final ConcurrentHashMap<String, DroneApi> connectedApps = new ConcurrentHashMap();
    protected final Context context;
    protected final Handler handler;
    protected T drone;
    protected final ConnectionParameter connectionParameter;

    public static DroneManager generateDroneManager(Context context, ConnectionParameter connParams, Handler handler) {
        switch (connParams.getConnectionType()) {
            default: 
        }
        return new MavLinkDroneManager(context, connParams, handler);
    }

    protected DroneManager(Context context, ConnectionParameter connParams, Handler handler) {
        this.context = context;
        this.handler = handler;
        this.connectionParameter = connParams;
    }

    private void destroyAutopilot() {
        if (this.drone == null) {
            return;
        }
        this.drone.destroy();
        this.drone = null;
    }

    public void destroy() {
        Log.d((String)TAG, (String)"Destroying drone manager.");
        this.disconnect();
        this.destroyAutopilot();
        this.connectedApps.clear();
    }

    public synchronized void connect(String appId, DroneApi listener, ConnectionParameter connParams) {
        if (listener == null || TextUtils.isEmpty((CharSequence)appId)) {
            return;
        }
        this.connectedApps.put(appId, listener);
        this.doConnect(appId, listener, connParams);
    }

    protected void doConnect(String appId, DroneApi listener, ConnectionParameter connParams) {
    }

    private void disconnect() {
        if (!this.connectedApps.isEmpty()) {
            for (DroneApi client : this.connectedApps.values()) {
                this.disconnect(client.getClientInfo());
            }
        }
    }

    protected boolean isCompanionComputerEnabled() {
        int connectionType = this.connectionParameter.getConnectionType();
        return this.drone instanceof ArduSolo || connectionType == 1 && SoloComp.isAvailable(this.context) || connectionType == 101;
    }

    public int getConnectedAppsCount() {
        return this.connectedApps.size();
    }

    public void disconnect(DroneApi.ClientInfo clientInfo) {
        String appId = clientInfo.appId;
        if (TextUtils.isEmpty((CharSequence)appId)) {
            return;
        }
        Log.d((String)TAG, (String)("Disconnecting client " + appId));
        DroneApi listener = this.connectedApps.remove(appId);
        this.doDisconnect(appId, listener);
    }

    protected void doDisconnect(String appId, DroneApi listener) {
        if (this.isConnected() && listener != null) {
            listener.onDroneEvent(DroneInterfaces.DroneEventsType.DISCONNECTED, (Drone)this.drone);
        }
        if (this.connectedApps.isEmpty()) {
            this.executeAsyncAction(null, new Action("com.o3dr.services.android.action.gimbal.RESET_GIMBAL_MOUNT_MODE"), null);
        }
    }

    protected void notifyDroneEvent(DroneInterfaces.DroneEventsType event) {
        if (this.drone != null) {
            this.drone.notifyDroneEvent(event);
        }
    }

    @Override
    public void notifyReceivedData(D data) {
    }

    @Override
    public void onConnectionStatus(LinkConnectionStatus connectionStatus) {
        switch (connectionStatus.getStatusCode()) {
            case "DISCONNECTED": {
                this.notifyDroneEvent(DroneInterfaces.DroneEventsType.DISCONNECTED);
                break;
            }
            case "CONNECTING": {
                this.notifyDroneEvent(DroneInterfaces.DroneEventsType.CONNECTING);
            }
        }
        if (this.connectedApps.isEmpty()) {
            return;
        }
        for (DroneApi droneEventsListener : this.connectedApps.values()) {
            droneEventsListener.onConnectionStatus(connectionStatus);
        }
    }

    public T getDrone() {
        return this.drone;
    }

    public boolean isConnected() {
        return this.drone != null && this.drone.isConnected();
    }

    public DroneAttribute getAttribute(DroneApi.ClientInfo clientInfo, String attributeType) {
        switch (attributeType) {
            default: 
        }
        return this.drone == null ? null : this.drone.getAttribute(attributeType);
    }

    protected boolean executeAsyncAction(Action action, ICommandListener listener) {
        String type;
        switch (type = action.getType()) {
            case "com.o3dr.services.android.lib.drone.action.control.ENABLE_MANUAL_CONTROL": {
                if (this.drone != null) {
                    this.drone.executeAsyncAction(action, listener);
                } else {
                    CommonApiUtils.postErrorEvent(4, listener);
                }
                return true;
            }
        }
        if (this.drone != null) {
            return this.drone.executeAsyncAction(action, listener);
        }
        CommonApiUtils.postErrorEvent(4, listener);
        return true;
    }

    public boolean executeAsyncAction(DroneApi.ClientInfo clientInfo, Action action, ICommandListener listener) {
        String type = action.getType();
        Bundle data = action.getData();
        switch (type) {
            case "com.o3dr.services.android.lib.drone.action.control.ENABLE_MANUAL_CONTROL": {
                data.putString(EXTRA_CLIENT_APP_ID, clientInfo.appId);
            }
        }
        return this.executeAsyncAction(action, listener);
    }

    protected void notifyDroneAttributeEvent(String attributeEvent, Bundle eventInfo) {
        if (TextUtils.isEmpty((CharSequence)attributeEvent) || this.connectedApps.isEmpty()) {
            return;
        }
        for (DroneApi listener : this.connectedApps.values()) {
            listener.onAttributeEvent(attributeEvent, eventInfo);
        }
    }

    public void onDroneEvent(DroneInterfaces.DroneEventsType event, Drone drone) {
        switch (event) {
            case HEARTBEAT_FIRST: 
            case CONNECTED: {
                event = DroneInterfaces.DroneEventsType.CONNECTED;
            }
        }
        if (this.connectedApps.isEmpty()) {
            return;
        }
        for (DroneApi droneEventsListener : this.connectedApps.values()) {
            droneEventsListener.onDroneEvent(event, drone);
        }
    }

    @Override
    public void onBeginReceivingParameters() {
        if (this.connectedApps.isEmpty()) {
            return;
        }
        for (DroneApi droneEventsListener : this.connectedApps.values()) {
            droneEventsListener.onBeginReceivingParameters();
        }
    }

    @Override
    public void onParameterReceived(Parameter parameter, int index, int count) {
        if (this.connectedApps.isEmpty()) {
            return;
        }
        for (DroneApi droneEventsListener : this.connectedApps.values()) {
            droneEventsListener.onParameterReceived(parameter, index, count);
        }
    }

    @Override
    public void onEndReceivingParameters() {
        if (this.connectedApps.isEmpty()) {
            return;
        }
        for (DroneApi droneEventsListener : this.connectedApps.values()) {
            droneEventsListener.onEndReceivingParameters();
        }
    }

    public ConnectionParameter getConnectionParameter() {
        return this.connectionParameter;
    }

    @Override
    public void onMessageLogged(int logLevel, String message) {
        if (this.connectedApps.isEmpty()) {
            return;
        }
        for (DroneApi listener : this.connectedApps.values()) {
            listener.onMessageLogged(logLevel, message);
        }
    }

    @Override
    public void onAttributeEvent(String attributeEvent, Bundle eventInfo) {
        this.notifyDroneAttributeEvent(attributeEvent, eventInfo);
    }
}

