/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.MAVLink;

import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.common.msg_command_ack;
import com.MAVLink.common.msg_command_long;
import com.o3dr.services.android.lib.model.ICommandListener;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;

public class MavLinkCalibration {
    public static void sendCalibrationAckMessage(MavLinkDrone drone, int count) {
        msg_command_ack msg = new msg_command_ack();
        msg.command = count;
        msg.result = 1;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, null);
    }

    public static void startAccelerometerCalibration(MavLinkDrone drone, ICommandListener listener) {
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 241;
        msg.param1 = 0.0f;
        msg.param2 = 0.0f;
        msg.param3 = 0.0f;
        msg.param4 = 0.0f;
        msg.param5 = 1.0f;
        msg.param6 = 0.0f;
        msg.param7 = 0.0f;
        msg.confirmation = 0;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void startMagnetometerCalibration(MavLinkDrone drone, ICommandListener listener) {
        MavLinkCalibration.startMagnetometerCalibration(drone, false, false, 0, listener);
    }

    public static void startMagnetometerCalibration(MavLinkDrone drone, boolean retryOnFailure, boolean saveAutomatically, int startDelay, ICommandListener listener) {
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 42424;
        msg.param1 = 0.0f;
        msg.param2 = retryOnFailure ? 1.0f : 0.0f;
        msg.param3 = saveAutomatically ? 1.0f : 0.0f;
        msg.param4 = startDelay > 0 ? (float)startDelay : 0.0f;
        msg.param5 = 0.0f;
        msg.param6 = 0.0f;
        msg.param7 = 0.0f;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void cancelMagnetometerCalibration(MavLinkDrone drone, ICommandListener listener) {
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 42426;
        msg.param1 = 0.0f;
        msg.param2 = 0.0f;
        msg.param3 = 0.0f;
        msg.param4 = 0.0f;
        msg.param5 = 0.0f;
        msg.param6 = 0.0f;
        msg.param7 = 0.0f;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void acceptMagnetometerCalibration(MavLinkDrone drone, ICommandListener listener) {
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 42425;
        msg.param1 = 0.0f;
        msg.param2 = 0.0f;
        msg.param3 = 0.0f;
        msg.param4 = 0.0f;
        msg.param5 = 0.0f;
        msg.param6 = 0.0f;
        msg.param7 = 0.0f;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }
}

