/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.communication.connection.usb;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Bundle;
import android.util.Log;
import com.o3dr.services.android.lib.gcs.link.LinkConnectionStatus;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.droidplanner.services.android.impl.communication.connection.AndroidMavLinkConnection;
import org.droidplanner.services.android.impl.communication.connection.usb.UsbCDCConnection;
import org.droidplanner.services.android.impl.communication.connection.usb.UsbFTDIConnection;
import org.droidplanner.services.android.impl.core.model.Logger;
import org.droidplanner.services.android.impl.utils.AndroidLogger;

public class UsbConnection
extends AndroidMavLinkConnection {
    private static final String TAG = UsbConnection.class.getSimpleName();
    private static final int FTDI_DEVICE_VENDOR_ID = 1027;
    protected final int mBaudRate;
    private UsbConnectionImpl mUsbConnection;

    public UsbConnection(Context parentContext, int baudRate) {
        super(parentContext);
        this.mBaudRate = baudRate;
    }

    @Override
    protected void closeConnection() throws IOException {
        if (this.mUsbConnection != null) {
            this.mUsbConnection.closeUsbConnection();
        }
    }

    @Override
    protected void loadPreferences() {
    }

    @Override
    protected void openConnection(Bundle connectionExtras) throws IOException {
        UsbConnectionImpl tmp;
        if (this.mUsbConnection != null) {
            try {
                this.mUsbConnection.openUsbConnection(connectionExtras);
                Log.d((String)TAG, (String)"Reusing previous usb connection.");
                return;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Previous usb connection is not usable.", (Throwable)e);
                this.mUsbConnection = null;
            }
        }
        if (UsbConnection.isFTDIdevice(this.context)) {
            tmp = new UsbFTDIConnection(this.context, this, this.mBaudRate);
            try {
                tmp.openUsbConnection(connectionExtras);
                this.mUsbConnection = tmp;
                Log.d((String)TAG, (String)"Using FTDI usb connection.");
            }
            catch (IOException e) {
                Log.d((String)TAG, (String)"Unable to open a ftdi usb connection. Falling back to the open usb-library.", (Throwable)e);
            }
        }
        if (this.mUsbConnection == null) {
            tmp = new UsbCDCConnection(this.context, this, this.mBaudRate);
            tmp.openUsbConnection(connectionExtras);
            this.mUsbConnection = tmp;
            Log.d((String)TAG, (String)"Using open-source usb connection.");
        }
    }

    private static boolean isFTDIdevice(Context context) {
        UsbManager manager = (UsbManager)context.getSystemService("usb");
        HashMap deviceList = manager.getDeviceList();
        if (deviceList == null || deviceList.isEmpty()) {
            return false;
        }
        for (Map.Entry device : deviceList.entrySet()) {
            if (((UsbDevice)device.getValue()).getVendorId() != 1027) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int readDataBlock(byte[] buffer) throws IOException {
        if (this.mUsbConnection == null) {
            throw new IOException("Uninitialized usb connection.");
        }
        return this.mUsbConnection.readDataBlock(buffer);
    }

    @Override
    protected void sendBuffer(byte[] buffer) throws IOException {
        if (this.mUsbConnection == null) {
            throw new IOException("Uninitialized usb connection.");
        }
        this.mUsbConnection.sendBuffer(buffer);
    }

    @Override
    public int getConnectionType() {
        return 0;
    }

    public String toString() {
        if (this.mUsbConnection == null) {
            return TAG;
        }
        return this.mUsbConnection.toString();
    }

    static abstract class UsbConnectionImpl {
        protected final int mBaudRate;
        protected final Context mContext;
        private final UsbConnection parentConnection;
        protected final Logger mLogger = AndroidLogger.getLogger();

        protected UsbConnectionImpl(Context context, UsbConnection parentConn, int baudRate) {
            this.mContext = context;
            this.parentConnection = parentConn;
            this.mBaudRate = baudRate;
        }

        protected void onUsbConnectionOpened(Bundle extras) {
            this.parentConnection.onConnectionOpened(extras);
        }

        protected void onUsbConnectionStatus(LinkConnectionStatus connectionStatus) {
            this.parentConnection.onConnectionStatus(connectionStatus);
        }

        protected abstract void closeUsbConnection() throws IOException;

        protected abstract void openUsbConnection(Bundle var1) throws IOException;

        protected abstract int readDataBlock(byte[] var1) throws IOException;

        protected abstract void sendBuffer(byte[] var1);
    }
}

