/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.communication.connection;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.o3dr.services.android.lib.drone.connection.ConnectionParameter;
import com.o3dr.services.android.lib.gcs.link.LinkConnectionStatus;
import java.io.IOException;
import java.util.List;
import org.droidplanner.services.android.impl.communication.connection.AndroidMavLinkConnection;
import org.droidplanner.services.android.impl.communication.connection.AndroidUdpConnection;
import org.droidplanner.services.android.impl.utils.connection.WifiConnectionHandler;
import timber.log.Timber;

public class SoloConnection
extends AndroidMavLinkConnection
implements WifiConnectionHandler.WifiConnectionListener {
    private static final int SOLO_UDP_PORT = 14550;
    private final WifiConnectionHandler wifiHandler;
    private final AndroidUdpConnection dataLink;
    private final String soloLinkId;
    private final String soloLinkPassword;

    public SoloConnection(Context applicationContext, String soloLinkId, String password) {
        super(applicationContext);
        this.wifiHandler = new WifiConnectionHandler(applicationContext);
        this.wifiHandler.setListener(this);
        this.soloLinkId = soloLinkId;
        this.soloLinkPassword = password;
        this.dataLink = new AndroidUdpConnection(applicationContext, 14550){

            @Override
            protected void onConnectionOpened(Bundle extras) {
                SoloConnection.this.onConnectionOpened(extras);
            }

            @Override
            protected void onConnectionStatus(LinkConnectionStatus connectionStatus) {
                SoloConnection.this.onConnectionStatus(connectionStatus);
            }
        };
    }

    @Override
    protected void openConnection(Bundle connectionExtras) throws IOException {
        if (TextUtils.isEmpty((CharSequence)this.soloLinkId)) {
            LinkConnectionStatus connectionStatus = LinkConnectionStatus.newFailedConnectionStatus(-4, "Invalid connection credentials!");
            this.onConnectionStatus(connectionStatus);
        } else {
            this.wifiHandler.start();
            this.checkScanResults(this.wifiHandler.getScanResults());
        }
    }

    private void refreshWifiAps() {
        if (!this.wifiHandler.refreshWifiAPs()) {
            LinkConnectionStatus connectionStatus = LinkConnectionStatus.newFailedConnectionStatus(-1, "Unable to refresh wifi access points");
            this.onConnectionStatus(connectionStatus);
        }
    }

    @Override
    protected int readDataBlock(byte[] buffer) throws IOException {
        return this.dataLink.readDataBlock(buffer);
    }

    @Override
    protected void sendBuffer(byte[] buffer) throws IOException {
        this.dataLink.sendBuffer(buffer);
    }

    @Override
    protected void closeConnection() throws IOException {
        this.wifiHandler.stop();
        this.dataLink.closeConnection();
    }

    @Override
    protected void loadPreferences() {
        this.dataLink.loadPreferences();
    }

    @Override
    public int getConnectionType() {
        return this.dataLink.getConnectionType();
    }

    @Override
    public void onWifiConnected(String wifiSsid, Bundle extras) {
        if (this.isConnecting() && wifiSsid.equalsIgnoreCase(this.soloLinkId)) {
            try {
                this.dataLink.openConnection(extras);
            }
            catch (IOException e) {
                this.reportIOException(e);
                Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void onWifiConnecting() {
        this.onConnectionStatus(new LinkConnectionStatus("CONNECTING", null));
    }

    @Override
    public void onWifiDisconnected(String prevSsid) {
        if (prevSsid.equalsIgnoreCase(this.soloLinkId)) {
            this.onConnectionStatus(new LinkConnectionStatus("DISCONNECTED", null));
        }
    }

    @Override
    public void onWifiScanResultsAvailable(List<ScanResult> results) {
        this.checkScanResults(results);
    }

    @Override
    public void onWifiConnectionFailed(LinkConnectionStatus connectionStatus) {
        this.onConnectionStatus(connectionStatus);
    }

    private void checkScanResults(List<ScanResult> results) {
        if (!this.isConnecting()) {
            return;
        }
        ScanResult targetResult = null;
        for (ScanResult result : results) {
            if (!result.SSID.equalsIgnoreCase(this.soloLinkId)) continue;
            targetResult = result;
            break;
        }
        if (targetResult != null) {
            try {
                Bundle connectInfo = new Bundle();
                Bundle extras = this.getConnectionExtras();
                if (extras != null && !extras.isEmpty()) {
                    connectInfo.putAll(extras);
                }
                connectInfo.putParcelable("extra_scan_result", (Parcelable)targetResult);
                connectInfo.putString("extra_ssid_password", this.soloLinkPassword);
                int connectionResult = this.wifiHandler.connectToWifi(connectInfo);
                if (connectionResult != 0) {
                    int failureCode = connectionResult;
                    LinkConnectionStatus connectionStatus = LinkConnectionStatus.newFailedConnectionStatus(failureCode, "Unable to connect to the target wifi " + this.soloLinkId);
                    this.onConnectionStatus(connectionStatus);
                }
            }
            catch (IllegalArgumentException e) {
                Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                LinkConnectionStatus connectionStatus = LinkConnectionStatus.newFailedConnectionStatus(-7, e.getMessage());
                this.onConnectionStatus(connectionStatus);
            }
        } else {
            this.refreshWifiAps();
        }
    }

    private boolean isConnecting() {
        return this.getConnectionStatus() == 1;
    }

    public static boolean isUdpSoloConnection(Context context, ConnectionParameter connParam) {
        if (connParam == null) {
            return false;
        }
        int connectionType = connParam.getConnectionType();
        switch (connectionType) {
            case 1: {
                Bundle paramsBundle = connParam.getParamsBundle();
                if (paramsBundle == null) {
                    return false;
                }
                int serverPort = paramsBundle.getInt("extra_udp_server_port", 14550);
                String wifiSsid = WifiConnectionHandler.getCurrentWifiLink((WifiManager)context.getSystemService("wifi"));
                return WifiConnectionHandler.isSoloWifi(wifiSsid) && serverPort == 14550;
            }
        }
        return false;
    }

    public static ConnectionParameter getSoloConnectionParameterFromUdp(Context context, ConnectionParameter udpConnectionParameters) {
        if (context == null) {
            return null;
        }
        String wifiSsid = WifiConnectionHandler.getCurrentWifiLink((WifiManager)context.getSystemService("wifi"));
        if (WifiConnectionHandler.isSoloWifi(wifiSsid)) {
            return ConnectionParameter.newSoloConnection(wifiSsid, null, udpConnectionParameters.getTLogLoggingUri(), udpConnectionParameters.getEventsDispatchingPeriod());
        }
        return null;
    }
}

