/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.communication.connection;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.os.Bundle;
import android.os.ParcelUuid;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.UUID;
import org.droidplanner.services.android.impl.communication.connection.AndroidMavLinkConnection;

public class BluetoothConnection
extends AndroidMavLinkConnection {
    private static final String BLUE = "BLUETOOTH";
    private static final String UUID_SPP_DEVICE = "00001101-0000-1000-8000-00805F9B34FB";
    private BluetoothAdapter mBluetoothAdapter;
    private OutputStream out;
    private InputStream in;
    private BluetoothSocket bluetoothSocket;
    private final String bluetoothAddress;

    public BluetoothConnection(Context parentContext, String btAddress) {
        super(parentContext);
        this.bluetoothAddress = btAddress;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null) {
            Log.d((String)BLUE, (String)"Null adapters");
        }
    }

    @Override
    protected void openConnection(Bundle connectionExtras) throws IOException {
        Log.d((String)BLUE, (String)"Connect");
        this.resetConnection();
        BluetoothDevice device = null;
        try {
            device = this.mBluetoothAdapter.getRemoteDevice(this.bluetoothAddress);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (device == null) {
            device = this.findSerialBluetoothBoard();
        }
        Log.d((String)BLUE, (String)("Trying to connect to device with address " + device.getAddress()));
        Log.d((String)BLUE, (String)"BT Create Socket Call...");
        this.bluetoothSocket = device.createInsecureRfcommSocketToServiceRecord(UUID.fromString(UUID_SPP_DEVICE));
        Log.d((String)BLUE, (String)"BT Cancel Discovery Call...");
        this.mBluetoothAdapter.cancelDiscovery();
        Log.d((String)BLUE, (String)"BT Connect Call...");
        this.bluetoothSocket.connect();
        Log.d((String)BLUE, (String)"## BT Connected ##");
        this.out = this.bluetoothSocket.getOutputStream();
        this.in = this.bluetoothSocket.getInputStream();
        this.onConnectionOpened(connectionExtras);
    }

    @SuppressLint(value={"NewApi"})
    private BluetoothDevice findSerialBluetoothBoard() throws UnknownHostException {
        Set pairedDevices = this.mBluetoothAdapter.getBondedDevices();
        if (pairedDevices.size() > 0) {
            for (BluetoothDevice device : pairedDevices) {
                Log.d((String)BLUE, (String)(device.getName() + " #" + device.getAddress() + "#"));
                ParcelUuid[] deviceUuids = device.getUuids();
                if (deviceUuids == null || deviceUuids.length <= 0) continue;
                for (ParcelUuid id : device.getUuids()) {
                    Log.d((String)BLUE, (String)("id:" + id.toString()));
                    if (!id.toString().equalsIgnoreCase(UUID_SPP_DEVICE)) continue;
                    Log.d((String)BLUE, (String)(">> Selected: " + device.getName() + " Using: " + id.toString()));
                    return device;
                }
            }
        }
        throw new UnknownHostException("No Bluetooth Device found");
    }

    @Override
    protected int readDataBlock(byte[] buffer) throws IOException {
        return this.in.read(buffer);
    }

    @Override
    protected void sendBuffer(byte[] buffer) throws IOException {
        if (this.out != null) {
            this.out.write(buffer);
        }
    }

    @Override
    public int getConnectionType() {
        return 3;
    }

    @Override
    protected void closeConnection() throws IOException {
        this.resetConnection();
        Log.d((String)BLUE, (String)"## BT Closed ##");
    }

    private void resetConnection() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.bluetoothSocket != null) {
            this.bluetoothSocket.close();
            this.bluetoothSocket = null;
        }
    }

    @Override
    protected void loadPreferences() {
    }
}

