/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.api;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.o3dr.android.client.R;
import com.o3dr.services.android.lib.drone.connection.ConnectionParameter;
import com.o3dr.services.android.lib.drone.mission.item.complex.CameraDetail;
import com.o3dr.services.android.lib.model.IApiListener;
import com.o3dr.services.android.lib.model.IDroidPlannerServices;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.droidplanner.services.android.impl.api.DPServices;
import org.droidplanner.services.android.impl.api.DroneApi;
import org.droidplanner.services.android.impl.core.drone.DroneManager;
import org.droidplanner.services.android.impl.core.survey.CameraInfo;
import org.droidplanner.services.android.impl.utils.file.IO.CameraInfoLoader;
import timber.log.Timber;

public class DroidPlannerService
extends Service {
    private static final int FOREGROUND_ID = 101;
    public static final String ACTION_DRONE_CREATED = "org.droidplanner.services.android.ACTION_DRONE_CREATED";
    public static final String ACTION_DRONE_DESTROYED = "org.droidplanner.services.android.ACTION_DRONE_DESTROYED";
    public static final String ACTION_RELEASE_API_INSTANCE = "org.droidplanner.services.android.action.RELEASE_API_INSTANCE";
    public static final String EXTRA_API_INSTANCE_APP_ID = "extra_api_instance_app_id";
    private LocalBroadcastManager lbm;
    final ConcurrentHashMap<String, DroneApi> droneApiStore = new ConcurrentHashMap();
    final ConcurrentHashMap<ConnectionParameter, DroneManager> droneManagers = new ConcurrentHashMap();
    private DPServices dpServices;
    private CameraInfoLoader cameraInfoLoader;
    private List<CameraDetail> cachedCameraDetails;

    DroneApi registerDroneApi(IApiListener listener, String appId) {
        if (listener == null) {
            return null;
        }
        DroneApi droneApi = new DroneApi(this, listener, appId);
        this.droneApiStore.put(appId, droneApi);
        this.lbm.sendBroadcast(new Intent(ACTION_DRONE_CREATED));
        this.updateForegroundNotification();
        return droneApi;
    }

    void releaseDroneApi(String appId) {
        if (appId == null) {
            return;
        }
        DroneApi droneApi = this.droneApiStore.remove(appId);
        if (droneApi != null) {
            Timber.d((String)("Releasing drone api instance for " + appId), (Object[])new Object[0]);
            droneApi.destroy();
            this.lbm.sendBroadcast(new Intent(ACTION_DRONE_DESTROYED));
            this.updateForegroundNotification();
        }
    }

    DroneManager connectDroneManager(ConnectionParameter connParams, String appId, DroneApi listener) {
        if (connParams == null || TextUtils.isEmpty((CharSequence)appId) || listener == null) {
            return null;
        }
        DroneManager droneMgr = this.droneManagers.get(connParams);
        if (droneMgr == null) {
            DroneManager temp = DroneManager.generateDroneManager(this.getApplicationContext(), connParams, new Handler(Looper.getMainLooper()));
            droneMgr = this.droneManagers.putIfAbsent(connParams, temp);
            if (droneMgr == null) {
                Timber.d((String)"Generating new drone manager.", (Object[])new Object[0]);
                droneMgr = temp;
            } else {
                temp.destroy();
            }
        }
        Timber.d((String)("Drone manager connection for " + appId), (Object[])new Object[0]);
        droneMgr.connect(appId, listener, connParams);
        return droneMgr;
    }

    void disconnectDroneManager(DroneManager droneMgr, DroneApi.ClientInfo clientInfo) {
        if (droneMgr == null || clientInfo == null || TextUtils.isEmpty((CharSequence)clientInfo.appId)) {
            return;
        }
        String appId = clientInfo.appId;
        Timber.d((String)("Drone manager disconnection for " + appId), (Object[])new Object[0]);
        droneMgr.disconnect(clientInfo);
        if (droneMgr.getConnectedAppsCount() == 0) {
            Timber.d((String)"Destroying drone manager.", (Object[])new Object[0]);
            droneMgr.destroy();
            this.droneManagers.remove(droneMgr.getConnectionParameter());
        }
    }

    synchronized List<CameraDetail> getCameraDetails() {
        if (this.cachedCameraDetails == null) {
            List<String> cameraInfoNames = this.cameraInfoLoader.getCameraInfoList();
            ArrayList<CameraInfo> cameraInfos = new ArrayList<CameraInfo>(cameraInfoNames.size());
            for (String infoName : cameraInfoNames) {
                try {
                    cameraInfos.add(this.cameraInfoLoader.openFile(infoName));
                }
                catch (Exception e) {
                    Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                }
            }
            ArrayList<CameraDetail> cameraDetails = new ArrayList<CameraDetail>(cameraInfos.size());
            for (CameraInfo camInfo : cameraInfos) {
                cameraDetails.add(new CameraDetail(camInfo.name, camInfo.sensorWidth, camInfo.sensorHeight, camInfo.sensorResolution, camInfo.focalLength, camInfo.overlap, camInfo.sidelap, camInfo.isInLandscapeOrientation));
            }
            this.cachedCameraDetails = cameraDetails;
        }
        return this.cachedCameraDetails;
    }

    public IBinder onBind(Intent intent) {
        Timber.d((String)("Binding intent: " + intent), (Object[])new Object[0]);
        String action = intent.getAction();
        if (IDroidPlannerServices.class.getName().equals(action)) {
            return this.dpServices;
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    public void onCreate() {
        super.onCreate();
        Timber.d((String)"Creating DroneKit-Android.", (Object[])new Object[0]);
        Context context = this.getApplicationContext();
        this.dpServices = new DPServices(this);
        this.lbm = LocalBroadcastManager.getInstance((Context)context);
        this.cameraInfoLoader = new CameraInfoLoader(context);
        this.updateForegroundNotification();
    }

    @SuppressLint(value={"NewApi"})
    private void updateForegroundNotification() {
        Context context = this.getApplicationContext();
        NotificationCompat.Builder notifBuilder = new NotificationCompat.Builder(context).setContentTitle((CharSequence)"DroneKit-Android").setPriority(-2).setSmallIcon(R.drawable.ic_stat_notify);
        int connectedCount = this.droneApiStore.size();
        if (connectedCount > 1) {
            notifBuilder.setContentText((CharSequence)(connectedCount + " connected apps"));
        }
        Notification notification = notifBuilder.build();
        this.startForeground(101, notification);
    }

    public void onDestroy() {
        super.onDestroy();
        Timber.d((String)"Destroying DroneKit-Android.", (Object[])new Object[0]);
        for (DroneApi droneApi : this.droneApiStore.values()) {
            droneApi.destroy();
        }
        this.droneApiStore.clear();
        for (DroneManager droneMgr : this.droneManagers.values()) {
            droneMgr.destroy();
        }
        this.droneManagers.clear();
        this.dpServices.destroy();
        this.stopForeground(true);
        DroidPlannerService.enableDroidPlannerService(this.getApplicationContext(), false);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            String action;
            switch (action = intent.getAction()) {
                case "org.droidplanner.services.android.action.RELEASE_API_INSTANCE": {
                    String appId = intent.getStringExtra(EXTRA_API_INSTANCE_APP_ID);
                    this.releaseDroneApi(appId);
                }
            }
        }
        this.stopSelf();
        return 2;
    }

    public static void enableDroidPlannerService(Context context, boolean enable) {
        ComponentName serviceComp = new ComponentName(context, DroidPlannerService.class);
        int newState = enable ? 1 : 2;
        context.getPackageManager().setComponentEnabledSetting(serviceComp, newState, 1);
    }
}

