/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.api;

import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.o3dr.services.android.lib.drone.connection.ConnectionParameter;
import com.o3dr.services.android.lib.model.IApiListener;
import com.o3dr.services.android.lib.model.IDroidPlannerServices;
import com.o3dr.services.android.lib.model.IDroneApi;
import com.o3dr.services.android.lib.util.version.VersionUtils;
import java.util.ArrayList;
import org.droidplanner.services.android.impl.api.DroidPlannerService;
import org.droidplanner.services.android.impl.api.DroneApi;
import org.droidplanner.services.android.impl.core.drone.DroneManager;

final class DPServices
extends IDroidPlannerServices.Stub {
    private static final String TAG = DPServices.class.getSimpleName();
    private DroidPlannerService serviceRef;

    DPServices(DroidPlannerService service) {
        this.serviceRef = service;
    }

    void destroy() {
        this.serviceRef = null;
    }

    @Override
    public int getServiceVersionCode() throws RemoteException {
        return 300000;
    }

    @Override
    public int getApiVersionCode() throws RemoteException {
        return VersionUtils.getCoreLibVersion(this.serviceRef.getApplicationContext());
    }

    @Override
    public IDroneApi registerDroneApi(IApiListener listener, String appId) throws RemoteException {
        return this.serviceRef.registerDroneApi(listener, appId);
    }

    @Override
    public Bundle[] getConnectedApps(String requesterId) throws RemoteException {
        Log.d((String)TAG, (String)("List of connected apps request from " + requesterId));
        ArrayList<Bundle> appsInfo = new ArrayList<Bundle>();
        for (DroneApi droneApi : this.serviceRef.droneApiStore.values()) {
            DroneManager droneManager;
            if (!droneApi.isConnected() || (droneManager = droneApi.getDroneManager()) == null) continue;
            ConnectionParameter droneParams = droneApi.getDroneManager().getConnectionParameter();
            ConnectionParameter sanitizedParams = droneParams.clone();
            Bundle info = new Bundle();
            info.putString("com.o3dr.services.android.lib.gcs.event.extra.APP_ID", droneApi.getOwnerId());
            info.putParcelable("com.o3dr.services.android.lib.gcs.event.extra.VEHICLE_CONNECTION_PARAMETER", (Parcelable)sanitizedParams);
            appsInfo.add(info);
        }
        return appsInfo.toArray(new Bundle[appsInfo.size()]);
    }

    @Override
    public void releaseDroneApi(IDroneApi dpApi) throws RemoteException {
        Log.d((String)TAG, (String)"Releasing acquired drone api handle.");
        if (dpApi instanceof DroneApi) {
            this.serviceRef.releaseDroneApi(((DroneApi)dpApi).getOwnerId());
        }
    }
}

