/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.property;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import com.o3dr.services.android.lib.drone.property.EkfStatus;
import com.o3dr.services.android.lib.drone.property.VehicleMode;
import com.o3dr.services.android.lib.drone.property.Vibration;
import org.json.JSONException;
import org.json.JSONObject;

public class State
implements DroneAttribute {
    private static final String TAG = State.class.getSimpleName();
    public static final int INVALID_MAVLINK_VERSION = -1;
    private boolean isConnected;
    private boolean armed;
    private boolean isFlying;
    private String calibrationStatus;
    private String autopilotErrorId;
    private int mavlinkVersion = -1;
    private long flightStartTime;
    private VehicleMode vehicleMode = VehicleMode.UNKNOWN;
    private EkfStatus ekfStatus = new EkfStatus();
    private boolean isTelemetryLive;
    private Vibration vehicleVibration = new Vibration();
    private final JSONObject vehicleUid;
    public static final Parcelable.Creator<State> CREATOR = new Parcelable.Creator<State>(){

        public State createFromParcel(Parcel source) {
            return new State(source);
        }

        public State[] newArray(int size) {
            return new State[size];
        }
    };

    public State() {
        this.vehicleUid = new JSONObject();
    }

    public State(boolean isConnected, VehicleMode mode, boolean armed, boolean flying, String autopilotErrorId, int mavlinkVersion, String calibrationStatus, long flightStartTime, EkfStatus ekfStatus, boolean isTelemetryLive, Vibration vibration) {
        this.vehicleUid = new JSONObject();
        this.isConnected = isConnected;
        this.armed = armed;
        this.isFlying = flying;
        this.flightStartTime = flightStartTime;
        this.autopilotErrorId = autopilotErrorId;
        this.mavlinkVersion = mavlinkVersion;
        this.calibrationStatus = calibrationStatus;
        if (ekfStatus != null) {
            this.ekfStatus = ekfStatus;
        }
        if (mode != null) {
            this.vehicleMode = mode;
        }
        this.isTelemetryLive = isTelemetryLive;
        if (vibration != null) {
            this.vehicleVibration = vibration;
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    public void setArmed(boolean armed) {
        this.armed = armed;
    }

    public void setFlying(boolean isFlying) {
        this.isFlying = isFlying;
    }

    public void setCalibrationStatus(String calibrationStatus) {
        this.calibrationStatus = calibrationStatus;
    }

    public void setVehicleMode(VehicleMode vehicleMode) {
        this.vehicleMode = vehicleMode;
    }

    public void setMavlinkVersion(int mavlinkVersion) {
        this.mavlinkVersion = mavlinkVersion;
    }

    public boolean isArmed() {
        return this.armed;
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public VehicleMode getVehicleMode() {
        return this.vehicleMode;
    }

    public String getAutopilotErrorId() {
        return this.autopilotErrorId;
    }

    public void setAutopilotErrorId(String autopilotErrorId) {
        this.autopilotErrorId = autopilotErrorId;
    }

    public boolean isWarning() {
        return TextUtils.isEmpty((CharSequence)this.autopilotErrorId);
    }

    public boolean isCalibrating() {
        return this.calibrationStatus != null;
    }

    public void setCalibration(String message) {
        this.calibrationStatus = message;
    }

    public String getCalibrationStatus() {
        return this.calibrationStatus;
    }

    public int getMavlinkVersion() {
        return this.mavlinkVersion;
    }

    public long getFlightStartTime() {
        return this.flightStartTime;
    }

    public void setFlightStartTime(long flightStartTime) {
        this.flightStartTime = flightStartTime;
    }

    public boolean isTelemetryLive() {
        return this.isTelemetryLive;
    }

    public void setIsTelemetryLive(boolean isTelemetryLive) {
        this.isTelemetryLive = isTelemetryLive;
    }

    public EkfStatus getEkfStatus() {
        return this.ekfStatus;
    }

    public Vibration getVehicleVibration() {
        return this.vehicleVibration;
    }

    public JSONObject getVehicleUid() {
        return this.vehicleUid;
    }

    public void addToVehicleUid(String uidLabel, String uid) {
        try {
            this.vehicleUid.put(uidLabel, (Object)uid);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.isConnected ? (byte)1 : 0);
        dest.writeByte(this.armed ? (byte)1 : 0);
        dest.writeByte(this.isFlying ? (byte)1 : 0);
        dest.writeString(this.calibrationStatus);
        dest.writeParcelable((Parcelable)this.vehicleMode, 0);
        dest.writeString(this.autopilotErrorId);
        dest.writeInt(this.mavlinkVersion);
        dest.writeLong(this.flightStartTime);
        dest.writeParcelable((Parcelable)this.ekfStatus, 0);
        dest.writeByte(this.isTelemetryLive ? (byte)1 : 0);
        dest.writeParcelable((Parcelable)this.vehicleVibration, 0);
        dest.writeString(this.vehicleUid.toString());
    }

    private State(Parcel in) {
        JSONObject temp;
        this.isConnected = in.readByte() != 0;
        this.armed = in.readByte() != 0;
        this.isFlying = in.readByte() != 0;
        this.calibrationStatus = in.readString();
        this.vehicleMode = (VehicleMode)in.readParcelable(VehicleMode.class.getClassLoader());
        this.autopilotErrorId = in.readString();
        this.mavlinkVersion = in.readInt();
        this.flightStartTime = in.readLong();
        this.ekfStatus = (EkfStatus)in.readParcelable(EkfStatus.class.getClassLoader());
        this.isTelemetryLive = in.readByte() != 0;
        this.vehicleVibration = (Vibration)in.readParcelable(Vibration.class.getClassLoader());
        try {
            temp = new JSONObject(in.readString());
        }
        catch (JSONException e) {
            temp = new JSONObject();
        }
        this.vehicleUid = temp;
    }
}

