/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.property;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import com.o3dr.services.android.lib.drone.property.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Parameters
implements DroneAttribute {
    private final List<Parameter> parametersList = new ArrayList<Parameter>();
    public static final Parcelable.Creator<Parameters> CREATOR = new Parcelable.Creator<Parameters>(){

        public Parameters createFromParcel(Parcel source) {
            return new Parameters(source);
        }

        public Parameters[] newArray(int size) {
            return new Parameters[size];
        }
    };

    public Parameters() {
    }

    public Parameters(Collection<Parameter> parameterList) {
        this.setParametersList(parameterList);
    }

    public List<Parameter> getParameters() {
        return this.parametersList;
    }

    @Nullable
    public Parameter getParameter(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (Parameter param : this.parametersList) {
            if (!param.getName().equalsIgnoreCase(name)) continue;
            return param;
        }
        return null;
    }

    public void setParametersList(Collection<Parameter> parametersList) {
        this.parametersList.clear();
        if (parametersList != null && !parametersList.isEmpty()) {
            this.parametersList.addAll(parametersList);
        }
    }

    public void addParameter(@NonNull Parameter parameter) {
        if (parameter == null) {
            throw new NullPointerException("Invalid parameter argument.");
        }
        this.parametersList.add(parameter);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.parametersList);
    }

    private Parameters(Parcel in) {
        in.readTypedList(this.parametersList, Parameter.CREATOR);
    }
}

