/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.mission.item.complex;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.drone.mission.MissionItemType;
import com.o3dr.services.android.lib.drone.mission.item.MissionItem;
import com.o3dr.services.android.lib.drone.mission.item.complex.SurveyDetail;
import com.o3dr.services.android.lib.drone.mission.item.spatial.BaseSpatialItem;
import java.util.ArrayList;
import java.util.List;

public class StructureScanner
extends BaseSpatialItem
implements MissionItem.ComplexItem<StructureScanner>,
Parcelable {
    private double radius = 10.0;
    private double heightStep = 5.0;
    private int stepsCount = 2;
    private boolean crossHatch = false;
    private SurveyDetail surveyDetail = new SurveyDetail();
    private List<LatLong> path = new ArrayList<LatLong>();
    public static final Parcelable.Creator<StructureScanner> CREATOR = new Parcelable.Creator<StructureScanner>(){

        public StructureScanner createFromParcel(Parcel source) {
            return new StructureScanner(source);
        }

        public StructureScanner[] newArray(int size) {
            return new StructureScanner[size];
        }
    };

    public StructureScanner() {
        super(MissionItemType.STRUCTURE_SCANNER);
    }

    public StructureScanner(StructureScanner copy) {
        super(copy);
        this.copy(copy);
    }

    @Override
    public void copy(StructureScanner source) {
        this.radius = source.radius;
        this.heightStep = source.heightStep;
        this.stepsCount = source.stepsCount;
        this.crossHatch = source.crossHatch;
        this.surveyDetail = new SurveyDetail(source.surveyDetail);
        this.path = this.copyPointsList(source.path);
    }

    private List<LatLong> copyPointsList(List<LatLong> copy) {
        ArrayList<LatLong> dest = new ArrayList<LatLong>();
        for (LatLong itemCopy : copy) {
            dest.add(new LatLong(itemCopy));
        }
        return dest;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getHeightStep() {
        return this.heightStep;
    }

    public void setHeightStep(double heightStep) {
        this.heightStep = heightStep;
    }

    public int getStepsCount() {
        return this.stepsCount;
    }

    public void setStepsCount(int stepsCount) {
        this.stepsCount = stepsCount;
    }

    public boolean isCrossHatch() {
        return this.crossHatch;
    }

    public void setCrossHatch(boolean crossHatch) {
        this.crossHatch = crossHatch;
    }

    public SurveyDetail getSurveyDetail() {
        return this.surveyDetail;
    }

    public void setSurveyDetail(SurveyDetail surveyDetail) {
        this.surveyDetail = surveyDetail;
    }

    public List<LatLong> getPath() {
        return this.path;
    }

    public void setPath(List<LatLong> points) {
        this.path = points;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeDouble(this.radius);
        dest.writeDouble(this.heightStep);
        dest.writeInt(this.stepsCount);
        dest.writeByte(this.crossHatch ? (byte)1 : 0);
        dest.writeParcelable((Parcelable)this.surveyDetail, 0);
        dest.writeTypedList(this.path);
    }

    private StructureScanner(Parcel in) {
        super(in);
        this.radius = in.readDouble();
        this.heightStep = in.readDouble();
        this.stepsCount = in.readInt();
        this.crossHatch = in.readByte() != 0;
        this.surveyDetail = (SurveyDetail)in.readParcelable(SurveyDetail.class.getClassLoader());
        in.readTypedList(this.path, LatLong.CREATOR);
    }

    @Override
    public String toString() {
        return "StructureScanner{crossHatch=" + this.crossHatch + ", radius=" + this.radius + ", heightStep=" + this.heightStep + ", stepsCount=" + this.stepsCount + ", surveyDetail=" + this.surveyDetail + ", path=" + this.path + ", " + super.toString() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructureScanner)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StructureScanner that = (StructureScanner)o;
        if (Double.compare(that.radius, this.radius) != 0) {
            return false;
        }
        if (Double.compare(that.heightStep, this.heightStep) != 0) {
            return false;
        }
        if (this.stepsCount != that.stepsCount) {
            return false;
        }
        if (this.crossHatch != that.crossHatch) {
            return false;
        }
        if (this.surveyDetail != null ? !this.surveyDetail.equals(that.surveyDetail) : that.surveyDetail != null) {
            return false;
        }
        return !(this.path == null ? that.path != null : !this.path.equals(that.path));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.radius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.heightStep);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.stepsCount;
        result = 31 * result + (this.crossHatch ? 1 : 0);
        result = 31 * result + (this.surveyDetail != null ? this.surveyDetail.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    @Override
    public MissionItem clone() {
        return new StructureScanner(this);
    }
}

