/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo.tlv.mpcc;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import java.nio.ByteBuffer;

public class SoloSplineDurations
extends TLVPacket {
    public static final int MESSAGE_LENGTH = 8;
    private float minTime;
    private float maxTime;
    public static final Parcelable.Creator<SoloSplineDurations> CREATOR = new Parcelable.Creator<SoloSplineDurations>(){

        public SoloSplineDurations createFromParcel(Parcel source) {
            return new SoloSplineDurations(source);
        }

        public SoloSplineDurations[] newArray(int size) {
            return new SoloSplineDurations[size];
        }
    };

    public SoloSplineDurations(float minTime, float maxTime) {
        super(56, 8);
        this.maxTime = maxTime;
        this.minTime = minTime;
    }

    public SoloSplineDurations(ByteBuffer buffer) {
        this(buffer.getFloat(), buffer.getFloat());
    }

    @Override
    protected void getMessageValue(ByteBuffer valueCarrier) {
        valueCarrier.putFloat(this.minTime);
        valueCarrier.putFloat(this.maxTime);
    }

    public float getMaxTime() {
        return this.maxTime;
    }

    public float getMinTime() {
        return this.minTime;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeFloat(this.minTime);
        dest.writeFloat(this.maxTime);
    }

    protected SoloSplineDurations(Parcel in) {
        super(in);
        this.minTime = in.readFloat();
        this.maxTime = in.readFloat();
    }

    @Override
    public String toString() {
        return "SoloSplineDurations{minTime=" + this.minTime + ", maxTime=" + this.maxTime + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SoloSplineDurations that = (SoloSplineDurations)o;
        if (Float.compare(that.minTime, this.minTime) != 0) {
            return false;
        }
        return Float.compare(that.maxTime, this.maxTime) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.minTime != 0.0f ? Float.floatToIntBits(this.minTime) : 0);
        result = 31 * result + (this.maxTime != 0.0f ? Float.floatToIntBits(this.maxTime) : 0);
        return result;
    }
}

