/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo.tlv;

import android.util.Log;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.ControllerMessageInputReport;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloButtonSettingGetter;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloButtonSettingSetter;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloCableCamOptions;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloCableCamWaypoint;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloFollowOptions;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloFollowOptionsV2;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloGoproRecord;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloGoproRequestState;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloGoproSetExtendedRequest;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloGoproSetRequest;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloGoproState;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloGoproStateV2;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloMessageLocation;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloMessageRecordPosition;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloMessageShotGetter;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloMessageShotManagerError;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloMessageShotSetter;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloPanoOptions;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloPanoStatus;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloPause;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloReturnHomeLocationMessage;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloRewindOptions;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloShotError;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloShotOptions;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloZiplineLock;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloZiplineOptions;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.mpcc.SoloSplineAttach;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.mpcc.SoloSplineDurations;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.mpcc.SoloSplinePathSettings;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.mpcc.SoloSplinePlay;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.mpcc.SoloSplinePlaybackStatus;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.mpcc.SoloSplinePoint;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.mpcc.SoloSplineRecord;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.mpcc.SoloSplineSeek;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.sitescan.inspect.SoloInspectMoveGimbal;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.sitescan.inspect.SoloInspectMoveVehicle;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.sitescan.inspect.SoloInspectSetWaypoint;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.sitescan.inspect.SoloInspectStart;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.sitescan.scan.SoloScanStart;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.sitescan.survey.SoloSurveyStart;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class TLVMessageParser {
    private static final String TAG = TLVMessageParser.class.getSimpleName();

    public static List<TLVPacket> parseTLVPacket(byte[] packetData) {
        if (packetData == null || packetData.length == 0) {
            return null;
        }
        return TLVMessageParser.parseTLVPacket(ByteBuffer.wrap(packetData));
    }

    public static List<TLVPacket> parseTLVPacket(ByteBuffer packetBuffer) {
        ArrayList<TLVPacket> packetList = new ArrayList<TLVPacket>();
        if (packetBuffer == null) {
            return packetList;
        }
        int bufferSize = packetBuffer.limit();
        if (bufferSize <= 0) {
            return packetList;
        }
        ByteOrder originalOrder = packetBuffer.order();
        packetBuffer.order(TLVPacket.TLV_BYTE_ORDER);
        int messageType = -1;
        try {
            while (packetBuffer.remaining() >= 8) {
                messageType = packetBuffer.getInt();
                int messageLength = packetBuffer.getInt();
                int remaining = packetBuffer.remaining();
                Log.d((String)TAG, (String)String.format("Received message %d of with value of length %d. Remaining buffer size is %d", messageType, messageLength, remaining));
                if (messageLength <= remaining) {
                    TLVPacket packet = null;
                    packetBuffer.mark();
                    switch (messageType) {
                        case 0: 
                        case 1: {
                            int shotType = packetBuffer.getInt();
                            if (messageType == 0) {
                                packet = new SoloMessageShotGetter(shotType);
                                break;
                            }
                            packet = new SoloMessageShotSetter(shotType);
                            break;
                        }
                        case 2: {
                            double latitude = packetBuffer.getDouble();
                            double longitude = packetBuffer.getDouble();
                            float altitude = packetBuffer.getFloat();
                            packet = new SoloMessageLocation(latitude, longitude, altitude);
                            break;
                        }
                        case 3: {
                            packet = new SoloMessageRecordPosition();
                            break;
                        }
                        case 4: {
                            short camInterpolation = packetBuffer.getShort();
                            short yawDirectionClockwise = packetBuffer.getShort();
                            float cruiseSpeed = packetBuffer.getFloat();
                            packet = new SoloCableCamOptions(camInterpolation, yawDirectionClockwise, cruiseSpeed);
                            break;
                        }
                        case 5: 
                        case 6: {
                            int button = packetBuffer.getInt();
                            int event = packetBuffer.getInt();
                            int shotType = packetBuffer.getInt();
                            int flightMode = packetBuffer.getInt();
                            if (messageType == 5) {
                                packet = new SoloButtonSettingGetter(button, event, shotType, flightMode);
                                break;
                            }
                            packet = new SoloButtonSettingSetter(button, event, shotType, flightMode);
                            break;
                        }
                        case 19: {
                            packet = new SoloFollowOptions(packetBuffer);
                            break;
                        }
                        case 119: {
                            packet = new SoloFollowOptionsV2(packetBuffer);
                            break;
                        }
                        case 20: {
                            float cruiseSpeed = packetBuffer.getFloat();
                            packet = new SoloShotOptions(cruiseSpeed);
                            break;
                        }
                        case 21: {
                            int errorType = packetBuffer.getInt();
                            packet = new SoloShotError(errorType);
                            break;
                        }
                        case 1000: {
                            byte[] exceptionData = new byte[messageLength];
                            packetBuffer.get(exceptionData);
                            packet = new SoloMessageShotManagerError(new String(exceptionData));
                            break;
                        }
                        case 1001: {
                            double latitude = packetBuffer.getDouble();
                            double longitude = packetBuffer.getDouble();
                            float altitude = packetBuffer.getFloat();
                            float degreesYaw = packetBuffer.getFloat();
                            float pitch = packetBuffer.getFloat();
                            packet = new SoloCableCamWaypoint(latitude, longitude, altitude, degreesYaw, pitch);
                            break;
                        }
                        case 2003: {
                            double timestamp = packetBuffer.getDouble();
                            short gimbalY = packetBuffer.getShort();
                            short gimbalRate = packetBuffer.getShort();
                            short battery = packetBuffer.getShort();
                            packet = new ControllerMessageInputReport(timestamp, gimbalY, gimbalRate, battery);
                            break;
                        }
                        case 5001: {
                            short command = packetBuffer.getShort();
                            short value = packetBuffer.getShort();
                            packet = new SoloGoproSetRequest(command, value);
                            break;
                        }
                        case 5003: {
                            int command = packetBuffer.getInt();
                            packet = new SoloGoproRecord(command);
                            break;
                        }
                        case 5005: {
                            packet = new SoloGoproState(packetBuffer);
                            break;
                        }
                        case 5006: {
                            packet = new SoloGoproStateV2(packetBuffer);
                            break;
                        }
                        case 5007: {
                            packet = new SoloGoproRequestState();
                            break;
                        }
                        case 5009: {
                            short command = packetBuffer.getShort();
                            byte[] values = new byte[4];
                            packetBuffer.get(values);
                            packet = new SoloGoproSetExtendedRequest(command, values);
                            break;
                        }
                        case 50: {
                            packet = new SoloSplineRecord();
                            break;
                        }
                        case 51: {
                            packet = new SoloSplinePlay();
                            break;
                        }
                        case 52: {
                            packet = new SoloSplinePoint(packetBuffer);
                            break;
                        }
                        case 53: {
                            packet = new SoloSplineSeek(packetBuffer);
                            break;
                        }
                        case 54: {
                            packet = new SoloSplinePlaybackStatus(packetBuffer);
                            break;
                        }
                        case 55: {
                            packet = new SoloSplinePathSettings(packetBuffer);
                            break;
                        }
                        case 56: {
                            packet = new SoloSplineDurations(packetBuffer);
                            break;
                        }
                        case 57: {
                            packet = new SoloSplineAttach(packetBuffer);
                            break;
                        }
                        case 22: {
                            packet = new SoloPanoOptions(packetBuffer);
                            break;
                        }
                        case 25: {
                            packet = new SoloPanoStatus(packetBuffer);
                            break;
                        }
                        case 23: {
                            packet = new SoloZiplineOptions(packetBuffer);
                            break;
                        }
                        case 28: {
                            packet = new SoloZiplineLock();
                            break;
                        }
                        case 26: {
                            double latitude = packetBuffer.getDouble();
                            double longitude = packetBuffer.getDouble();
                            float altitude = packetBuffer.getFloat();
                            packet = new SoloReturnHomeLocationMessage(latitude, longitude, altitude);
                            break;
                        }
                        case 24: {
                            packet = new SoloRewindOptions(packetBuffer);
                            break;
                        }
                        case 10001: {
                            packet = new SoloInspectStart(packetBuffer);
                            break;
                        }
                        case 10002: {
                            packet = new SoloInspectSetWaypoint(packetBuffer);
                            break;
                        }
                        case 10003: {
                            packet = new SoloInspectMoveGimbal(packetBuffer);
                            break;
                        }
                        case 10004: {
                            packet = new SoloInspectMoveVehicle(packetBuffer);
                            break;
                        }
                        case 10101: {
                            packet = new SoloScanStart();
                            break;
                        }
                        case 10201: {
                            packet = new SoloSurveyStart();
                            break;
                        }
                        case 7: {
                            packet = new SoloPause();
                            break;
                        }
                    }
                    if (packet != null && packet.getMessageLength() == messageLength) {
                        packetList.add(packet);
                        continue;
                    }
                    packetBuffer.reset();
                    packetBuffer.position(packetBuffer.position() + messageLength);
                    continue;
                }
                break;
            }
        }
        catch (BufferUnderflowException e) {
            Log.e((String)TAG, (String)("Invalid data for tlv packet of type " + messageType));
        }
        packetBuffer.order(originalOrder);
        return packetList;
    }

    private TLVMessageParser() {
    }
}

