/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo.tlv;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import java.nio.ByteBuffer;

public class SoloCableCamWaypoint
extends TLVPacket {
    private LatLongAlt coordinate;
    private float degreesYaw;
    private float pitch;
    public static final Parcelable.Creator<SoloCableCamWaypoint> CREATOR = new Parcelable.Creator<SoloCableCamWaypoint>(){

        public SoloCableCamWaypoint createFromParcel(Parcel source) {
            return new SoloCableCamWaypoint(source);
        }

        public SoloCableCamWaypoint[] newArray(int size) {
            return new SoloCableCamWaypoint[size];
        }
    };

    public SoloCableCamWaypoint(double latitude, double longitude, float altitude, float degreesYaw, float pitch) {
        super(1001, 28);
        this.coordinate = new LatLongAlt(latitude, longitude, altitude);
        this.degreesYaw = degreesYaw;
        this.pitch = pitch;
    }

    public LatLongAlt getCoordinate() {
        return this.coordinate;
    }

    public float getDegreesYaw() {
        return this.degreesYaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    @Override
    protected void getMessageValue(ByteBuffer valueCarrier) {
        valueCarrier.putDouble(this.coordinate.getLatitude());
        valueCarrier.putDouble(this.coordinate.getLongitude());
        valueCarrier.putFloat((float)this.coordinate.getAltitude());
        valueCarrier.putFloat(this.degreesYaw);
        valueCarrier.putFloat(this.pitch);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.coordinate, 0);
        dest.writeFloat(this.degreesYaw);
        dest.writeFloat(this.pitch);
    }

    protected SoloCableCamWaypoint(Parcel in) {
        super(in);
        this.coordinate = (LatLongAlt)in.readParcelable(LatLongAlt.class.getClassLoader());
        this.degreesYaw = in.readFloat();
        this.pitch = in.readFloat();
    }
}

