/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.utils.unit;

import com.o3dr.android.client.utils.unit.UnitProvider;
import java.util.Locale;

public class MetricUnitProvider
implements UnitProvider {
    @Override
    public String areaToString(double areaInSqMeters) {
        double absArea = Math.abs(areaInSqMeters);
        if (absArea >= 100000.0) {
            return String.format(Locale.US, "%2.1f km\u00b2", areaInSqMeters / 1000000.0);
        }
        if (absArea >= 1.0) {
            return String.format(Locale.US, "%2.1f m\u00b2", areaInSqMeters);
        }
        if (absArea >= 1.0E-5) {
            return String.format(Locale.US, "%2.2f cm\u00b2", areaInSqMeters * 10000.0);
        }
        return areaInSqMeters + " m" + "\u00b2";
    }

    @Override
    public String distanceToString(double distanceInMeters) {
        double absDistance = Math.abs(distanceInMeters);
        if (absDistance >= 1000.0) {
            return String.format(Locale.US, "%2.1f km", distanceInMeters / 1000.0);
        }
        if (absDistance >= 0.1) {
            return String.format(Locale.US, "%2.1f m", distanceInMeters);
        }
        if (absDistance >= 0.001) {
            return String.format(Locale.US, "%2.1f mm", distanceInMeters * 1000.0);
        }
        return distanceInMeters + " m";
    }

    @Override
    public String speedToString(double speedInMetersPerSeconds) {
        return String.format(Locale.US, "%2.1f m/s", speedInMetersPerSeconds);
    }

    @Override
    public String electricChargeToString(double chargeInmAh) {
        double absCharge = Math.abs(chargeInmAh);
        if (absCharge >= 1000.0) {
            return String.format(Locale.US, "%2.0f Ah", chargeInmAh / 1000.0);
        }
        return String.format(Locale.ENGLISH, "%2.0f mAh", chargeInmAh);
    }
}

