/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import timber.log.Timber;

public class LogToFileTree
extends Timber.DebugTree {
    private static final SimpleDateFormat LOG_DATE_FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
    private static final SimpleDateFormat FILE_DATE_FORMAT = new SimpleDateFormat("yyyy_MM_dd_HH_mm", Locale.US);
    private final LinkedBlockingQueue<String> logQueue = new LinkedBlockingQueue();
    private PrintStream logOutputFile;
    private Thread dequeueThread;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final Date date = new Date();

    protected void log(int priority, String tag, String message, Throwable t) {
        super.log(priority, tag, message, t);
        if (this.isLoggableToFile(priority)) {
            String logOutput = this.getLogMessage(priority, tag, message);
            this.logQueue.add(logOutput);
        }
    }

    private boolean isLoggableToFile(int priority) {
        return priority >= 3;
    }

    private String getLogMessage(int priority, String tag, String message) {
        String priorityShort = this.getPriorityString(priority);
        this.date.setTime(System.currentTimeMillis());
        return String.format("%s %s/%s : %s", LOG_DATE_FORMAT.format(this.date), priorityShort, tag, message);
    }

    private String getPriorityString(int priority) {
        String priorityString = null;
        switch (priority) {
            case 7: {
                priorityString = "ASSERT";
                break;
            }
            case 6: {
                priorityString = "E";
                break;
            }
            case 5: {
                priorityString = "W";
                break;
            }
            case 4: {
                priorityString = "I";
                break;
            }
            case 3: {
                priorityString = "D";
                break;
            }
            case 2: {
                priorityString = "V";
                break;
            }
            default: {
                priorityString = "";
            }
        }
        return priorityString;
    }

    public void createFileStartLogging(final Context context) {
        if (this.dequeueThread != null && this.dequeueThread.isAlive()) {
            this.stopLoggingThread();
        }
        this.dequeueThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String version = "";
                try {
                    PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                    version = pInfo.versionName;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Timber.w((String)"Failed to get package info", (Object[])new Object[0]);
                }
                File rootDir = context.getExternalFilesDir(null);
                File dir = new File(rootDir, "/log_cat/");
                dir.mkdirs();
                String fileName = String.format("%s_%s.log", version, FILE_DATE_FORMAT.format(new Date()));
                File logFile = new File(dir, fileName);
                try {
                    LogToFileTree.this.logOutputFile = new PrintStream(new FileOutputStream(logFile, true));
                    while (LogToFileTree.this.isRunning.get()) {
                        try {
                            String message = (String)LogToFileTree.this.logQueue.take();
                            LogToFileTree.this.logOutputFile.println(message);
                        }
                        catch (InterruptedException e) {
                            Timber.w((String)"Failed to receive message from logQueue", (Object[])new Object[0]);
                        }
                    }
                }
                catch (IOException e) {
                    Timber.w((String)"Failed to open file", (Object[])new Object[0]);
                }
                finally {
                    LogToFileTree.this.isRunning.set(false);
                    if (LogToFileTree.this.logOutputFile != null) {
                        LogToFileTree.this.logOutputFile.close();
                    }
                }
            }
        });
        this.isRunning.set(true);
        this.dequeueThread.start();
    }

    public void stopLoggingThread() {
        if (this.dequeueThread != null) {
            this.isRunning.set(false);
            this.dequeueThread.interrupt();
            this.dequeueThread = null;
        }
    }
}

