/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.apis;

import android.location.Location;
import android.os.Bundle;
import android.os.Parcelable;
import com.o3dr.android.client.Drone;
import com.o3dr.android.client.apis.Api;
import com.o3dr.services.android.lib.gcs.follow.FollowLocationSource;
import com.o3dr.services.android.lib.gcs.follow.FollowType;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.concurrent.ConcurrentHashMap;

public class FollowApi
extends Api {
    private static final ConcurrentHashMap<Drone, FollowApi> followApiCache = new ConcurrentHashMap();
    private static final Api.Builder<FollowApi> apiBuilder = new Api.Builder<FollowApi>(){

        @Override
        public FollowApi build(Drone drone) {
            return new FollowApi(drone);
        }
    };
    private final Drone drone;

    public static FollowApi getApi(Drone drone) {
        return FollowApi.getApi(drone, followApiCache, apiBuilder);
    }

    private FollowApi(Drone drone) {
        this.drone = drone;
    }

    public void enableFollowMe(FollowType type, FollowLocationSource source) {
        Bundle params = new Bundle();
        params.putParcelable("extra_follow_type", (Parcelable)type);
        params.putParcelable("extra_location_source", (Parcelable)source);
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.ENABLE_FOLLOW_ME", params));
    }

    public void enableFollowMe(FollowType type) {
        this.enableFollowMe(type, FollowLocationSource.INTERNAL);
    }

    public void updateFollowParams(Bundle params) {
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.UPDATE_FOLLOW_PARAMS", params));
    }

    public void disableFollowMe() {
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.DISABLE_FOLLOW_ME"));
    }

    public void updateLocation(Location loc) {
        Bundle params = new Bundle();
        params.putParcelable("extra_location", (Parcelable)loc);
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.NEW_EXTERNAL_LOCATION", params));
    }
}

