/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.util;

import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;

public class SpannableUtils {
    private SpannableUtils() {
    }

    private static CharSequence apply(CharSequence[] content, Object ... tags) {
        SpannableStringBuilder text = new SpannableStringBuilder();
        SpannableUtils.openTags((Spannable)text, tags);
        for (CharSequence item : content) {
            text.append(item);
        }
        SpannableUtils.closeTags((Spannable)text, tags);
        return text;
    }

    private static void openTags(Spannable text, Object[] tags) {
        for (Object tag : tags) {
            text.setSpan(tag, 0, 0, 17);
        }
    }

    private static void closeTags(Spannable text, Object[] tags) {
        int len = text.length();
        for (Object tag : tags) {
            if (len > 0) {
                text.setSpan(tag, 0, len, 33);
                continue;
            }
            text.removeSpan(tag);
        }
    }

    public static CharSequence bold(CharSequence ... content) {
        return SpannableUtils.apply(content, new StyleSpan(1));
    }

    public static CharSequence italic(CharSequence ... content) {
        return SpannableUtils.apply(content, new StyleSpan(2));
    }

    public static CharSequence normal(CharSequence ... content) {
        return SpannableUtils.apply(content, new StyleSpan(0));
    }

    public static CharSequence color(int color, CharSequence ... content) {
        return SpannableUtils.apply(content, new ForegroundColorSpan(color));
    }
}

