/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.property;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import com.o3dr.services.android.lib.drone.property.EkfStatus;

public class Gps
implements DroneAttribute {
    public static final String LOCK_2D = "2D";
    public static final String LOCK_3D = "3D";
    public static final String LOCK_3D_DGPS = "3D+DGPS";
    public static final String LOCK_3D_RTK = "3D+RTK";
    public static final String NO_FIX = "NoFix";
    private static final int LOCK_2D_TYPE = 2;
    private static final int LOCK_3D_TYPE = 3;
    private static final int LOCK_3D_DGPS_TYPE = 4;
    private static final int LOCK_3D_RTK_TYPE = 5;
    private double gpsEph;
    private int satCount;
    private int fixType;
    private LatLong position;
    private boolean vehicleArmed;
    private EkfStatus ekfStatus;
    public static final Parcelable.Creator<Gps> CREATOR = new Parcelable.Creator<Gps>(){

        public Gps createFromParcel(Parcel source) {
            return new Gps(source);
        }

        public Gps[] newArray(int size) {
            return new Gps[size];
        }
    };

    public Gps() {
    }

    public Gps(LatLong position, double gpsEph, int satCount, int fixType) {
        this.position = position;
        this.gpsEph = gpsEph;
        this.satCount = satCount;
        this.fixType = fixType;
    }

    public Gps(double latitude, double longitude, double gpsEph, int satCount, int fixType) {
        this(new LatLong(latitude, longitude), gpsEph, satCount, fixType);
    }

    public boolean isValid() {
        if (this.ekfStatus == null) {
            return this.position != null;
        }
        return this.ekfStatus.isPositionOk(this.vehicleArmed) && this.position != null;
    }

    public double getGpsEph() {
        return this.gpsEph;
    }

    public int getSatellitesCount() {
        return this.satCount;
    }

    public int getFixType() {
        return this.fixType;
    }

    public String getFixStatus() {
        switch (this.fixType) {
            case 2: {
                return LOCK_2D;
            }
            case 3: {
                return LOCK_3D;
            }
            case 4: {
                return LOCK_3D_DGPS;
            }
            case 5: {
                return LOCK_3D_RTK;
            }
        }
        return NO_FIX;
    }

    public LatLong getPosition() {
        if (this.isValid()) {
            return this.position;
        }
        return null;
    }

    public void setGpsEph(double gpsEph) {
        this.gpsEph = gpsEph;
    }

    public void setSatCount(int satCount) {
        this.satCount = satCount;
    }

    public void setFixType(int fixType) {
        this.fixType = fixType;
    }

    public void setPosition(LatLong position) {
        this.position = position;
    }

    public void setEkfStatus(EkfStatus ekfStatus) {
        this.ekfStatus = ekfStatus;
    }

    public void setVehicleArmed(boolean vehicleArmed) {
        this.vehicleArmed = vehicleArmed;
    }

    public boolean has3DLock() {
        return this.fixType == 3 || this.fixType == 4 || this.fixType == 5;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Gps)) {
            return false;
        }
        Gps gps = (Gps)o;
        if (this.fixType != gps.fixType) {
            return false;
        }
        if (Double.compare(gps.gpsEph, this.gpsEph) != 0) {
            return false;
        }
        if (this.satCount != gps.satCount) {
            return false;
        }
        if (this.position != null ? !this.position.equals(gps.position) : gps.position != null) {
            return false;
        }
        if (this.vehicleArmed != gps.vehicleArmed) {
            return false;
        }
        return !(this.ekfStatus != null ? !this.ekfStatus.equals(gps.ekfStatus) : gps.ekfStatus != null);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.gpsEph);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + this.satCount;
        result = 31 * result + this.fixType;
        result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
        result = 31 * result + (this.vehicleArmed ? 1 : 0);
        result = 31 * result + (this.ekfStatus != null ? this.ekfStatus.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Gps{gpsEph=" + this.gpsEph + ", satCount=" + this.satCount + ", fixType=" + this.fixType + ", position=" + this.position + ", vehicleArmed=" + this.vehicleArmed + ", ekfStatus=" + this.ekfStatus + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.gpsEph);
        dest.writeInt(this.satCount);
        dest.writeInt(this.fixType);
        dest.writeParcelable((Parcelable)this.position, 0);
        dest.writeByte((byte)(this.vehicleArmed ? 1 : 0));
        dest.writeParcelable((Parcelable)this.ekfStatus, 0);
    }

    private Gps(Parcel in) {
        this.gpsEph = in.readDouble();
        this.satCount = in.readInt();
        this.fixType = in.readInt();
        this.position = (LatLong)in.readParcelable(LatLong.class.getClassLoader());
        this.vehicleArmed = in.readByte() != 0;
        this.ekfStatus = (EkfStatus)in.readParcelable(EkfStatus.class.getClassLoader());
    }
}

