/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.property;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import com.o3dr.services.android.lib.util.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class FootPrint
implements DroneAttribute {
    private double meanGSD;
    private List<LatLong> vertex = new ArrayList<LatLong>();
    public static final Parcelable.Creator<FootPrint> CREATOR = new Parcelable.Creator<FootPrint>(){

        public FootPrint createFromParcel(Parcel source) {
            return new FootPrint(source);
        }

        public FootPrint[] newArray(int size) {
            return new FootPrint[size];
        }
    };

    public FootPrint() {
    }

    public FootPrint(double meanGSD, List<LatLong> vertex) {
        this.meanGSD = meanGSD;
        this.vertex = vertex;
    }

    public void setMeanGSD(double meanGSD) {
        this.meanGSD = meanGSD;
    }

    public void setVertex(List<LatLong> vertex) {
        this.vertex = vertex;
    }

    public double getMeanGSD() {
        return this.meanGSD;
    }

    public List<LatLong> getVertexInGlobalFrame() {
        return this.vertex;
    }

    public double getLateralSize() {
        return (MathUtils.getDistance2D(this.vertex.get(0), this.vertex.get(1)) + MathUtils.getDistance2D(this.vertex.get(2), this.vertex.get(3))) / 2.0;
    }

    public double getLongitudinalSize() {
        return (MathUtils.getDistance2D(this.vertex.get(0), this.vertex.get(3)) + MathUtils.getDistance2D(this.vertex.get(1), this.vertex.get(2))) / 2.0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.meanGSD);
        dest.writeTypedList(this.vertex);
    }

    private FootPrint(Parcel in) {
        this.meanGSD = in.readDouble();
        in.readTypedList(this.vertex, LatLong.CREATOR);
    }
}

