/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.mission.item.complex;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.drone.mission.MissionItemType;
import com.o3dr.services.android.lib.drone.mission.item.MissionItem;
import com.o3dr.services.android.lib.drone.mission.item.complex.SurveyDetail;
import com.o3dr.services.android.lib.util.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class Survey
extends MissionItem
implements MissionItem.ComplexItem<Survey>,
Parcelable {
    private SurveyDetail surveyDetail = new SurveyDetail();
    private double polygonArea;
    private List<LatLong> polygonPoints;
    private List<LatLong> gridPoints;
    private List<LatLong> cameraLocations;
    private boolean isValid;
    private boolean startCameraBeforeFirstWaypoint;
    public static final Parcelable.Creator<Survey> CREATOR = new Parcelable.Creator<Survey>(){

        public Survey createFromParcel(Parcel source) {
            return new Survey(source);
        }

        public Survey[] newArray(int size) {
            return new Survey[size];
        }
    };

    public Survey() {
        this(MissionItemType.SURVEY);
    }

    protected Survey(MissionItemType type) {
        super(type);
        this.surveyDetail.setAltitude(50.0);
        this.surveyDetail.setAngle(0.0);
        this.surveyDetail.setOverlap(50.0);
        this.surveyDetail.setSidelap(60.0);
        this.polygonPoints = new ArrayList<LatLong>();
        this.gridPoints = new ArrayList<LatLong>();
        this.cameraLocations = new ArrayList<LatLong>();
    }

    public Survey(Survey copy) {
        this();
        this.copy(copy);
    }

    @Override
    public void copy(Survey source) {
        this.surveyDetail = new SurveyDetail(source.surveyDetail);
        this.polygonArea = source.polygonArea;
        this.polygonPoints = this.copyPointsList(source.polygonPoints);
        this.gridPoints = this.copyPointsList(source.gridPoints);
        this.cameraLocations = this.copyPointsList(source.cameraLocations);
        this.isValid = source.isValid;
        this.startCameraBeforeFirstWaypoint = source.startCameraBeforeFirstWaypoint;
    }

    private List<LatLong> copyPointsList(List<LatLong> copy) {
        ArrayList<LatLong> dest = new ArrayList<LatLong>();
        for (LatLong itemCopy : copy) {
            dest.add(new LatLong(itemCopy));
        }
        return dest;
    }

    public SurveyDetail getSurveyDetail() {
        return this.surveyDetail;
    }

    public void setSurveyDetail(SurveyDetail surveyDetail) {
        this.surveyDetail = surveyDetail;
    }

    public double getPolygonArea() {
        return this.polygonArea;
    }

    public void setPolygonArea(double polygonArea) {
        this.polygonArea = polygonArea;
    }

    public List<LatLong> getPolygonPoints() {
        return this.polygonPoints;
    }

    public void setPolygonPoints(List<LatLong> polygonPoints) {
        this.polygonPoints = polygonPoints;
    }

    public List<LatLong> getGridPoints() {
        return this.gridPoints;
    }

    public void setGridPoints(List<LatLong> gridPoints) {
        this.gridPoints = gridPoints;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public double getGridLength() {
        return MathUtils.getPolylineLength(this.gridPoints);
    }

    public int getNumberOfLines() {
        return this.gridPoints.size() / 2;
    }

    public List<LatLong> getCameraLocations() {
        return this.cameraLocations;
    }

    public void setCameraLocations(List<LatLong> cameraLocations) {
        this.cameraLocations = cameraLocations;
    }

    public boolean isStartCameraBeforeFirstWaypoint() {
        return this.startCameraBeforeFirstWaypoint;
    }

    public void setStartCameraBeforeFirstWaypoint(boolean startCameraBeforeFirstWaypoint) {
        this.startCameraBeforeFirstWaypoint = startCameraBeforeFirstWaypoint;
    }

    public int getCameraCount() {
        return this.getCameraLocations().size();
    }

    @Override
    public String toString() {
        return "Survey{cameraLocations=" + this.cameraLocations + ", surveyDetail=" + this.surveyDetail + ", polygonArea=" + this.polygonArea + ", polygonPoints=" + this.polygonPoints + ", gridPoints=" + this.gridPoints + ", isValid=" + this.isValid + ", startCameraBeforeFirstWaypoint=" + this.startCameraBeforeFirstWaypoint + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Survey)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Survey survey = (Survey)o;
        if (Double.compare(survey.polygonArea, this.polygonArea) != 0) {
            return false;
        }
        if (this.isValid != survey.isValid) {
            return false;
        }
        if (this.startCameraBeforeFirstWaypoint != survey.startCameraBeforeFirstWaypoint) {
            return false;
        }
        if (this.surveyDetail != null ? !this.surveyDetail.equals(survey.surveyDetail) : survey.surveyDetail != null) {
            return false;
        }
        if (this.polygonPoints != null ? !this.polygonPoints.equals(survey.polygonPoints) : survey.polygonPoints != null) {
            return false;
        }
        if (this.gridPoints != null ? !this.gridPoints.equals(survey.gridPoints) : survey.gridPoints != null) {
            return false;
        }
        return !(this.cameraLocations == null ? survey.cameraLocations != null : !this.cameraLocations.equals(survey.cameraLocations));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.surveyDetail != null ? this.surveyDetail.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.polygonArea);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.polygonPoints != null ? this.polygonPoints.hashCode() : 0);
        result = 31 * result + (this.gridPoints != null ? this.gridPoints.hashCode() : 0);
        result = 31 * result + (this.cameraLocations != null ? this.cameraLocations.hashCode() : 0);
        result = 31 * result + (this.isValid ? 1 : 0);
        result = 31 * result + (this.startCameraBeforeFirstWaypoint ? 1 : 0);
        return result;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.surveyDetail, 0);
        dest.writeDouble(this.polygonArea);
        dest.writeTypedList(this.polygonPoints);
        dest.writeTypedList(this.gridPoints);
        dest.writeTypedList(this.cameraLocations);
        dest.writeByte(this.isValid ? (byte)1 : 0);
        dest.writeByte(this.startCameraBeforeFirstWaypoint ? (byte)1 : 0);
    }

    protected Survey(Parcel in) {
        super(in);
        this.surveyDetail.setAltitude(50.0);
        this.surveyDetail.setAngle(0.0);
        this.surveyDetail.setOverlap(50.0);
        this.surveyDetail.setSidelap(60.0);
        this.polygonPoints = new ArrayList<LatLong>();
        this.gridPoints = new ArrayList<LatLong>();
        this.cameraLocations = new ArrayList<LatLong>();
        this.surveyDetail = (SurveyDetail)in.readParcelable(SurveyDetail.class.getClassLoader());
        this.polygonArea = in.readDouble();
        in.readTypedList(this.polygonPoints, LatLong.CREATOR);
        in.readTypedList(this.gridPoints, LatLong.CREATOR);
        in.readTypedList(this.cameraLocations, LatLong.CREATOR);
        this.isValid = in.readByte() != 0;
        this.startCameraBeforeFirstWaypoint = in.readByte() != 0;
    }

    @Override
    public MissionItem clone() {
        return new Survey(this);
    }
}

