/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.mission.item.command;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.mission.MissionItemType;
import com.o3dr.services.android.lib.drone.mission.item.MissionItem;

public class YawCondition
extends MissionItem
implements MissionItem.Command,
Parcelable {
    private double angle;
    private double angularSpeed;
    private boolean isRelative;
    public static final Parcelable.Creator<YawCondition> CREATOR = new Parcelable.Creator<YawCondition>(){

        public YawCondition createFromParcel(Parcel source) {
            return new YawCondition(source);
        }

        public YawCondition[] newArray(int size) {
            return new YawCondition[size];
        }
    };

    public YawCondition() {
        super(MissionItemType.YAW_CONDITION);
    }

    public YawCondition(YawCondition copy) {
        this();
        this.angle = copy.angle;
        this.angularSpeed = copy.angularSpeed;
        this.isRelative = copy.isRelative;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getAngularSpeed() {
        return this.angularSpeed;
    }

    public void setAngularSpeed(double angularSpeed) {
        this.angularSpeed = angularSpeed;
    }

    public boolean isRelative() {
        return this.isRelative;
    }

    public void setRelative(boolean isRelative) {
        this.isRelative = isRelative;
    }

    @Override
    public String toString() {
        return "YawCondition{angle=" + this.angle + ", angularSpeed=" + this.angularSpeed + ", isRelative=" + this.isRelative + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof YawCondition)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        YawCondition that = (YawCondition)o;
        if (Double.compare(that.angle, this.angle) != 0) {
            return false;
        }
        if (Double.compare(that.angularSpeed, this.angularSpeed) != 0) {
            return false;
        }
        return this.isRelative == that.isRelative;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.angle);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.angularSpeed);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.isRelative ? 1 : 0);
        return result;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeDouble(this.angle);
        dest.writeDouble(this.angularSpeed);
        dest.writeByte(this.isRelative ? (byte)1 : 0);
    }

    private YawCondition(Parcel in) {
        super(in);
        this.angle = in.readDouble();
        this.angularSpeed = in.readDouble();
        this.isRelative = in.readByte() != 0;
    }

    @Override
    public MissionItem clone() {
        return new YawCondition(this);
    }
}

