/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.connection;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public class DroneSharePrefs
implements Parcelable {
    private final String username;
    private final String password;
    private final boolean isEnabled;
    private final boolean enableLiveUpload;
    public static final Parcelable.Creator<DroneSharePrefs> CREATOR = new Parcelable.Creator<DroneSharePrefs>(){

        public DroneSharePrefs createFromParcel(Parcel source) {
            return new DroneSharePrefs(source);
        }

        public DroneSharePrefs[] newArray(int size) {
            return new DroneSharePrefs[size];
        }
    };

    public DroneSharePrefs(String username, String password, boolean isEnabled, boolean enableLiveUpload) {
        this.username = username;
        this.password = password;
        this.isEnabled = isEnabled;
        this.enableLiveUpload = enableLiveUpload;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isLiveUploadEnabled() {
        return this.isEnabled && this.enableLiveUpload;
    }

    public boolean areLoginCredentialsSet() {
        return !TextUtils.isEmpty((CharSequence)this.username) && !TextUtils.isEmpty((CharSequence)this.password);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DroneSharePrefs)) {
            return false;
        }
        DroneSharePrefs that = (DroneSharePrefs)o;
        if (this.enableLiveUpload != that.enableLiveUpload) {
            return false;
        }
        if (this.isEnabled != that.isEnabled) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public int hashCode() {
        int result = this.username != null ? this.username.hashCode() : 0;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.isEnabled ? 1 : 0);
        result = 31 * result + (this.enableLiveUpload ? 1 : 0);
        return result;
    }

    public String toString() {
        return "DroneSharePrefs{username='" + this.username + '\'' + ", isEnabled=" + this.isEnabled + ", enableLiveUpload=" + this.enableLiveUpload + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.username);
        dest.writeString(this.password);
        dest.writeByte(this.isEnabled ? (byte)1 : 0);
        dest.writeByte(this.enableLiveUpload ? (byte)1 : 0);
    }

    private DroneSharePrefs(Parcel in) {
        this.username = in.readString();
        this.password = in.readString();
        this.isEnabled = in.readByte() != 0;
        this.enableLiveUpload = in.readByte() != 0;
    }
}

