/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo.tlv.mpcc;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import java.nio.ByteBuffer;

public class SoloSplinePathSettings
extends TLVPacket {
    public static final int MESSAGE_LENGTH = 8;
    public static final int AUTO_POINT_CAMERA = 0;
    public static final int FREE_LOOK = 1;
    private int cameraControl;
    private float desiredTime;
    public static final Parcelable.Creator<SoloSplinePathSettings> CREATOR = new Parcelable.Creator<SoloSplinePathSettings>(){

        public SoloSplinePathSettings createFromParcel(Parcel source) {
            return new SoloSplinePathSettings(source);
        }

        public SoloSplinePathSettings[] newArray(int size) {
            return new SoloSplinePathSettings[size];
        }
    };

    public SoloSplinePathSettings(int cameraControl, float desiredTime) {
        super(55, 8);
        this.cameraControl = cameraControl;
        this.desiredTime = desiredTime;
    }

    public SoloSplinePathSettings(ByteBuffer buffer) {
        this(buffer.getInt(), (float)buffer.getInt());
    }

    public int getCameraControl() {
        return this.cameraControl;
    }

    public float getDesiredTime() {
        return this.desiredTime;
    }

    @Override
    protected void getMessageValue(ByteBuffer valueCarrier) {
        valueCarrier.putInt(this.cameraControl);
        valueCarrier.putFloat(this.desiredTime);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.cameraControl);
        dest.writeFloat(this.desiredTime);
    }

    protected SoloSplinePathSettings(Parcel in) {
        super(in);
        this.cameraControl = in.readInt();
        this.desiredTime = in.readFloat();
    }

    @Override
    public String toString() {
        return "SoloSplinePathSettings{cameraControl=" + this.cameraControl + ", desiredTime=" + this.desiredTime + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoloSplinePathSettings)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SoloSplinePathSettings that = (SoloSplinePathSettings)o;
        if (this.cameraControl != that.cameraControl) {
            return false;
        }
        return Float.compare(that.desiredTime, this.desiredTime) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.cameraControl;
        result = 31 * result + (this.desiredTime != 0.0f ? Float.floatToIntBits(this.desiredTime) : 0);
        return result;
    }

    public static @interface CameraControl {
    }
}

