/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import com.o3dr.android.client.utils.TxPowerComplianceCountries;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloButtonSetting;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVMessageParser;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import java.nio.ByteBuffer;
import java.util.List;

public class SoloState
implements DroneAttribute {
    private String wifiSsid;
    private String wifiPassword;
    private String controllerVersion;
    private String controllerFirmwareVersion;
    private String vehicleVersion;
    private String autopilotVersion;
    private String gimbalVersion;
    private String txPowerCompliantCountry;
    private SparseArray<SoloButtonSetting> buttonSettings;
    private int controllerMode;
    private String controllerUnit;
    public static final Parcelable.Creator<SoloState> CREATOR = new Parcelable.Creator<SoloState>(){

        public SoloState createFromParcel(Parcel source) {
            return new SoloState(source);
        }

        public SoloState[] newArray(int size) {
            return new SoloState[size];
        }
    };

    public SoloState() {
    }

    public SoloState(String autopilotVersion, String controllerFirmwareVersion, String controllerVersion, String vehicleVersion, String wifiPassword, String wifiSsid, String txPowerCompliantCountry, SparseArray<SoloButtonSetting> buttonSettings, String gimbalVersion, int controllerMode, String controllerUnit) {
        this.autopilotVersion = autopilotVersion;
        this.controllerFirmwareVersion = controllerFirmwareVersion;
        this.controllerVersion = controllerVersion;
        this.vehicleVersion = vehicleVersion;
        this.wifiPassword = wifiPassword;
        this.wifiSsid = wifiSsid;
        this.txPowerCompliantCountry = txPowerCompliantCountry;
        this.buttonSettings = buttonSettings;
        this.gimbalVersion = gimbalVersion;
        this.controllerMode = controllerMode;
        this.controllerUnit = controllerUnit;
    }

    public String getAutopilotVersion() {
        return this.autopilotVersion;
    }

    public String getControllerFirmwareVersion() {
        return this.controllerFirmwareVersion;
    }

    public String getControllerVersion() {
        return this.controllerVersion;
    }

    public int getControllerMode() {
        return this.controllerMode;
    }

    public String getVehicleVersion() {
        return this.vehicleVersion;
    }

    public String getWifiPassword() {
        return this.wifiPassword;
    }

    public String getWifiSsid() {
        return this.wifiSsid;
    }

    public boolean isEUTxPowerCompliant() {
        return !TxPowerComplianceCountries.getDefaultCountry().name().equals(this.txPowerCompliantCountry);
    }

    public String getTxPowerCompliantCountry() {
        return this.txPowerCompliantCountry;
    }

    public SoloButtonSetting getButtonSetting(int buttonType) {
        return (SoloButtonSetting)this.buttonSettings.get(buttonType);
    }

    public String getGimbalVersion() {
        return this.gimbalVersion;
    }

    public String getControllerUnit() {
        return this.controllerUnit;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.wifiSsid);
        dest.writeString(this.wifiPassword);
        dest.writeString(this.controllerVersion);
        dest.writeString(this.controllerFirmwareVersion);
        dest.writeString(this.vehicleVersion);
        dest.writeString(this.autopilotVersion);
        dest.writeByte(this.isEUTxPowerCompliant() ? (byte)1 : 0);
        int buttonCount = this.buttonSettings.size();
        dest.writeInt(buttonCount);
        for (int i = 0; i < buttonCount; ++i) {
            SoloButtonSetting buttonSetting = (SoloButtonSetting)this.buttonSettings.valueAt(i);
            if (buttonSetting == null) {
                dest.writeInt(0);
                continue;
            }
            byte[] buttonData = buttonSetting.toBytes();
            dest.writeInt(buttonData.length);
            dest.writeByteArray(buttonData);
        }
        dest.writeString(this.gimbalVersion);
        dest.writeInt(this.controllerMode);
        dest.writeString(this.controllerUnit);
        dest.writeString(this.txPowerCompliantCountry);
    }

    protected SoloState(Parcel in) {
        String tempUnit;
        int tempMode;
        this.wifiSsid = in.readString();
        this.wifiPassword = in.readString();
        this.controllerVersion = in.readString();
        this.controllerFirmwareVersion = in.readString();
        this.vehicleVersion = in.readString();
        this.autopilotVersion = in.readString();
        in.readByte();
        int buttonCount = in.readInt();
        this.buttonSettings = new SparseArray(buttonCount);
        for (int i = 0; i < buttonCount; ++i) {
            int dataSize = in.readInt();
            if (dataSize == 0) continue;
            ByteBuffer dataBuffer = ByteBuffer.allocate(dataSize);
            in.readByteArray(dataBuffer.array());
            List<TLVPacket> buttonsList = TLVMessageParser.parseTLVPacket(dataBuffer);
            if (buttonsList.isEmpty()) continue;
            for (TLVPacket tlvPacket : buttonsList) {
                if (!(tlvPacket instanceof SoloButtonSetting)) continue;
                SoloButtonSetting button = (SoloButtonSetting)tlvPacket;
                this.buttonSettings.put(button.getButton(), (Object)button);
            }
        }
        this.gimbalVersion = in.readString();
        this.controllerMode = tempMode = in.readInt();
        this.controllerUnit = tempUnit = in.readString();
        this.txPowerCompliantCountry = in.readString();
    }
}

