/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.utils.geotag;

import android.media.ExifInterface;
import com.MAVLink.ardupilotmega.msg_camera_feedback;
import com.o3dr.android.client.utils.data.tlog.TLogParser;
import com.o3dr.android.client.utils.geotag.GeoTagAsyncTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeoTagUtils {
    private GeoTagUtils() {
    }

    public static ResultObject geotag(File saveDir, List<TLogParser.Event> events, ArrayList<File> photos, GeoTagAsyncTask.GeoTagAlgorithm geoTagAlg, GeoTagListener listener) {
        ResultObject resultObject = new ResultObject();
        try {
            HashMap<TLogParser.Event, File> eventsPhotos = new HashMap<TLogParser.Event, File>();
            HashMap<File, File> geoTaggedFiles = new HashMap<File, File>();
            HashMap<File, Exception> failedFiles = new HashMap<File, Exception>();
            resultObject.setResult(eventsPhotos, geoTaggedFiles, failedFiles);
            if (!saveDir.mkdirs()) {
                resultObject.setException(new IllegalStateException("Failed to create directory for images"));
                return resultObject;
            }
            HashMap<TLogParser.Event, File> matchedPhotos = geoTagAlg.match(events, photos);
            if (matchedPhotos == null || matchedPhotos.isEmpty()) {
                resultObject.setException(new IllegalStateException("Unable to match the media set for geotagging."));
                return resultObject;
            }
            if (!GeoTagUtils.hasEnoughMemory(saveDir, matchedPhotos.values())) {
                resultObject.setException(new IllegalStateException("Insufficient external storage space."));
                return resultObject;
            }
            int numTotal = matchedPhotos.size();
            int numProcessed = 0;
            for (Map.Entry<TLogParser.Event, File> entry : matchedPhotos.entrySet()) {
                File photo = entry.getValue();
                TLogParser.Event event = entry.getKey();
                File newFile = new File(saveDir, photo.getName());
                try {
                    GeoTagUtils.copyFile(photo, newFile);
                    GeoTagUtils.updateExif(event, newFile);
                    eventsPhotos.put(event, newFile);
                    geoTaggedFiles.put(photo, newFile);
                }
                catch (Exception e) {
                    failedFiles.put(photo, e);
                }
                ++numProcessed;
                if (listener == null) continue;
                listener.onProgress(numProcessed, numTotal);
            }
        }
        catch (Exception e) {
            resultObject.setException(e);
        }
        return resultObject;
    }

    private static boolean hasEnoughMemory(File file, Collection<File> photos) {
        long freeBytes = file.getUsableSpace();
        long bytesNeeded = 0L;
        for (File photo : photos) {
            bytesNeeded += photo.length();
        }
        return bytesNeeded <= freeBytes;
    }

    private static void copyFile(File inputPath, File outputPath) throws IOException {
        int read;
        FileInputStream in = new FileInputStream(inputPath);
        FileOutputStream out = new FileOutputStream(outputPath);
        byte[] buffer = new byte[1024];
        while ((read = ((InputStream)in).read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, read);
        }
        ((InputStream)in).close();
        out.flush();
        ((OutputStream)out).close();
    }

    private static void updateExif(TLogParser.Event event, File photoFile) throws IOException {
        msg_camera_feedback msg = (msg_camera_feedback)event.getMavLinkMessage();
        double lat = (double)msg.lat / 1.0E7;
        double lng = (double)msg.lng / 1.0E7;
        String alt = String.valueOf(msg.alt_msl);
        ExifInterface exifInterface = new ExifInterface(photoFile.getPath());
        exifInterface.setAttribute("GPSLongitude", GeoTagUtils.convertLatLngToDMS(lng));
        exifInterface.setAttribute("GPSLatitude", GeoTagUtils.convertLatLngToDMS(lat));
        exifInterface.setAttribute("GPSLatitudeRef", lat < 0.0 ? "S" : "N");
        exifInterface.setAttribute("GPSLongitudeRef", lng < 0.0 ? "W" : "E");
        exifInterface.setAttribute("GPSAltitude", alt);
        exifInterface.saveAttributes();
    }

    private static String convertLatLngToDMS(double coord) {
        double dDegree = Math.abs(coord);
        int degree = (int)dDegree;
        double dMinute = (dDegree - (double)degree) * 60.0;
        int minute = (int)dMinute;
        double dSecond = (dMinute - (double)minute) * 60.0;
        int second = (int)(dSecond * 1000.0);
        return String.format("%s/1,%s/1,%s/1000", degree, minute, second);
    }

    public static class ResultObject {
        private boolean didSucceed;
        private HashMap<TLogParser.Event, File> eventsPhotos;
        private HashMap<File, File> geoTaggedPhotos;
        private HashMap<File, Exception> failedFiles;
        private Exception exception;

        public boolean didSucceed() {
            return this.didSucceed;
        }

        public void setResult(HashMap<TLogParser.Event, File> eventsPhotos, HashMap<File, File> geoTaggedPhotos, HashMap<File, Exception> failedFiles) {
            this.didSucceed = true;
            this.eventsPhotos = eventsPhotos;
            this.geoTaggedPhotos = geoTaggedPhotos;
            this.failedFiles = failedFiles;
        }

        public HashMap<File, File> getGeoTaggedPhotos() {
            return this.geoTaggedPhotos;
        }

        public HashMap<TLogParser.Event, File> getEventsPhotos() {
            return this.eventsPhotos;
        }

        public HashMap<File, Exception> getFailedFiles() {
            return this.failedFiles;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.didSucceed = false;
            this.exception = exception;
        }
    }

    public static interface GeoTagListener {
        public void onProgress(int var1, int var2);
    }
}

