/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.apis.solo;

import android.os.Bundle;
import android.os.Parcelable;
import com.o3dr.android.client.Drone;
import com.o3dr.android.client.apis.Api;
import com.o3dr.android.client.apis.solo.SoloApi;
import com.o3dr.android.client.utils.TxPowerComplianceCountries;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloButtonSettingSetter;
import com.o3dr.services.android.lib.model.AbstractCommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.concurrent.ConcurrentHashMap;

public class SoloConfigApi
extends SoloApi {
    private static final ConcurrentHashMap<Drone, SoloConfigApi> soloConfigApiCache = new ConcurrentHashMap();
    private static final Api.Builder<SoloConfigApi> apiBuilder = new Api.Builder<SoloConfigApi>(){

        @Override
        public SoloConfigApi build(Drone drone) {
            return new SoloConfigApi(drone);
        }
    };

    public static SoloConfigApi getApi(Drone drone) {
        return SoloConfigApi.getApi(drone, soloConfigApiCache, apiBuilder);
    }

    protected SoloConfigApi(Drone drone) {
        super(drone);
    }

    public void updateWifiSettings(String wifiSsid, String wifiPassword, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putString("extra_wifi_ssid", wifiSsid);
        params.putString("extra_wifi_password", wifiPassword);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.companion.solo.action.config.UPDATE_WIFI_SETTINGS", params), listener);
    }

    public void updateButtonSettings(SoloButtonSettingSetter buttonSettings, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putParcelable("extra_button_settings", (Parcelable)buttonSettings);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.companion.solo.action.config.UPDATE_BUTTON_SETTINGS", params), listener);
    }

    public void updateControllerMode(int controllerMode, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putInt("extra_controller_mode", controllerMode);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.companion.solo.action.config.UPDATE_CONTROLLER_MODE", params), listener);
    }

    public void updateEUTxPowerCompliance(boolean isEUCompliant, AbstractCommandListener listener) {
        TxPowerComplianceCountries compliantCountry = isEUCompliant ? TxPowerComplianceCountries.getDefaultEUCountry() : TxPowerComplianceCountries.getDefaultCountry();
        this.updateTxPowerComplianceCountry(compliantCountry, listener);
    }

    public void updateTxPowerComplianceCountry(TxPowerComplianceCountries compliantCountry, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putString("extra_tx_power_compliant_country_code", compliantCountry.name());
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.companion.solo.action.config.UPDATE_TX_POWER_COMPLIANCE_COUNTRY", params), listener);
    }

    public void refreshSoloVersions() {
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.companion.solo.action.config.REFRESH_SOLO_VERSIONS"), null);
    }

    public void updateControllerUnit(String controllerUnit, final AbstractCommandListener listener) {
        if ("unknown".equals(controllerUnit)) {
            if (listener != null) {
                this.drone.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onError(2);
                    }
                });
            }
            return;
        }
        Bundle params = new Bundle();
        params.putString("extra_controller_unit", controllerUnit);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.companion.solo.action.config.UPDATE_CONTROLLER_UNIT", params), listener);
    }
}

