/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.apis;

import com.o3dr.android.client.Drone;
import com.o3dr.services.android.lib.model.AbstractCommandListener;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Api {
    protected static <T extends Api> T getApi(Drone drone, ConcurrentHashMap<Drone, T> apiCache, Builder<T> apiBuilder) {
        Api previousInstance;
        if (drone == null || apiCache == null) {
            return null;
        }
        Api apiInstance = (Api)apiCache.get(drone);
        if (apiInstance == null && apiBuilder != null && (previousInstance = apiCache.putIfAbsent(drone, apiInstance = apiBuilder.build(drone))) != null) {
            apiInstance = previousInstance;
        }
        return (T)apiInstance;
    }

    protected static void postSuccessEvent(AbstractCommandListener listener) {
        if (listener != null) {
            listener.onSuccess();
        }
    }

    protected static void postErrorEvent(int error, AbstractCommandListener listener) {
        if (listener != null) {
            listener.onError(error);
        }
    }

    protected static void postTimeoutEvent(AbstractCommandListener listener) {
        if (listener != null) {
            listener.onTimeout();
        }
    }

    protected static interface Builder<T extends Api> {
        public T build(Drone var1);
    }
}

