/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import com.o3dr.android.client.ControlTower;
import com.o3dr.android.client.DroneApiListener;
import com.o3dr.android.client.DroneObserver;
import com.o3dr.android.client.MavlinkObserver;
import com.o3dr.android.client.apis.CalibrationApi;
import com.o3dr.android.client.apis.ControlApi;
import com.o3dr.android.client.apis.ExperimentalApi;
import com.o3dr.android.client.apis.FollowApi;
import com.o3dr.android.client.apis.MissionApi;
import com.o3dr.android.client.apis.VehicleApi;
import com.o3dr.android.client.interfaces.DroneListener;
import com.o3dr.android.client.interfaces.LinkListener;
import com.o3dr.android.client.utils.TxPowerComplianceCountries;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.drone.calibration.magnetometer.MagnetometerCalibrationStatus;
import com.o3dr.services.android.lib.drone.connection.ConnectionParameter;
import com.o3dr.services.android.lib.drone.connection.ConnectionResult;
import com.o3dr.services.android.lib.drone.mission.Mission;
import com.o3dr.services.android.lib.drone.mission.item.MissionItem;
import com.o3dr.services.android.lib.drone.property.Altitude;
import com.o3dr.services.android.lib.drone.property.Attitude;
import com.o3dr.services.android.lib.drone.property.Battery;
import com.o3dr.services.android.lib.drone.property.Gps;
import com.o3dr.services.android.lib.drone.property.GuidedState;
import com.o3dr.services.android.lib.drone.property.Home;
import com.o3dr.services.android.lib.drone.property.Parameter;
import com.o3dr.services.android.lib.drone.property.Parameters;
import com.o3dr.services.android.lib.drone.property.Signal;
import com.o3dr.services.android.lib.drone.property.Speed;
import com.o3dr.services.android.lib.drone.property.State;
import com.o3dr.services.android.lib.drone.property.Type;
import com.o3dr.services.android.lib.drone.property.VehicleMode;
import com.o3dr.services.android.lib.gcs.follow.FollowState;
import com.o3dr.services.android.lib.gcs.follow.FollowType;
import com.o3dr.services.android.lib.gcs.link.LinkConnectionStatus;
import com.o3dr.services.android.lib.gcs.returnToMe.ReturnToMeState;
import com.o3dr.services.android.lib.mavlink.MavlinkMessageWrapper;
import com.o3dr.services.android.lib.model.AbstractCommandListener;
import com.o3dr.services.android.lib.model.IDroneApi;
import com.o3dr.services.android.lib.model.IObserver;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;

public class Drone {
    private static final String CLAZZ_NAME = Drone.class.getName();
    private static final String TAG = Drone.class.getSimpleName();
    public static final int COLLISION_SECONDS_BEFORE_COLLISION = 2;
    public static final double COLLISION_DANGEROUS_SPEED_METERS_PER_SECOND = -3.0;
    public static final double COLLISION_SAFE_ALTITUDE_METERS = 1.0;
    public static final String ACTION_GROUND_COLLISION_IMMINENT = CLAZZ_NAME + ".ACTION_GROUND_COLLISION_IMMINENT";
    public static final String EXTRA_IS_GROUND_COLLISION_IMMINENT = "extra_is_ground_collision_imminent";
    private final IBinder.DeathRecipient binderDeathRecipient = new IBinder.DeathRecipient(){

        public void binderDied() {
            Drone.this.notifyDroneServiceInterrupted("Lost access to the drone api.");
        }
    };
    private final ConcurrentLinkedQueue<DroneListener> droneListeners = new ConcurrentLinkedQueue();
    private Handler handler;
    private ControlTower serviceMgr;
    private DroneObserver droneObserver;
    private DroneApiListener apiListener;
    private final AtomicReference<IDroneApi> droneApiRef = new AtomicReference<Object>(null);
    private ConnectionParameter connectionParameter;
    private LinkListener linkListener;
    private ExecutorService asyncScheduler;
    private long startTime = 0L;
    private long elapsedFlightTime = 0L;
    private final Context context;
    private final ClassLoader contextClassLoader;

    public Drone(Context context) {
        this.context = context;
        this.contextClassLoader = context.getClassLoader();
    }

    void init(ControlTower controlTower, Handler handler) {
        this.handler = handler;
        this.serviceMgr = controlTower;
        this.apiListener = new DroneApiListener(this);
        this.droneObserver = new DroneObserver(this);
    }

    Context getContext() {
        return this.context;
    }

    synchronized void start() {
        if (!this.serviceMgr.isTowerConnected()) {
            throw new IllegalStateException("Service manager must be connected.");
        }
        IDroneApi droneApi = this.droneApiRef.get();
        if (this.isStarted(droneApi)) {
            return;
        }
        try {
            droneApi = this.serviceMgr.get3drServices().registerDroneApi(this.apiListener, this.serviceMgr.getApplicationId());
            droneApi.asBinder().linkToDeath(this.binderDeathRecipient, 0);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Unable to retrieve a valid drone handle.");
        }
        if (this.asyncScheduler == null || this.asyncScheduler.isShutdown()) {
            this.asyncScheduler = Executors.newFixedThreadPool(1);
        }
        this.addAttributesObserver(droneApi, this.droneObserver);
        this.resetFlightTimer();
        this.droneApiRef.set(droneApi);
    }

    synchronized void destroy() {
        IDroneApi droneApi = this.droneApiRef.get();
        this.removeAttributesObserver(droneApi, this.droneObserver);
        try {
            if (this.isStarted(droneApi)) {
                droneApi.asBinder().unlinkToDeath(this.binderDeathRecipient, 0);
                this.serviceMgr.get3drServices().releaseDroneApi(droneApi);
            }
        }
        catch (RemoteException | NoSuchElementException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        if (this.asyncScheduler != null) {
            this.asyncScheduler.shutdownNow();
            this.asyncScheduler = null;
        }
        this.droneApiRef.set(null);
    }

    private void checkForGroundCollision() {
        Speed speed = (Speed)this.getAttribute("com.o3dr.services.android.lib.attribute.SPEED");
        Altitude altitude = (Altitude)this.getAttribute("com.o3dr.services.android.lib.attribute.ALTITUDE");
        if (speed == null || altitude == null) {
            return;
        }
        double verticalSpeed = speed.getVerticalSpeed();
        double altitudeValue = altitude.getAltitude();
        boolean isCollisionImminent = altitudeValue + verticalSpeed * 2.0 < 0.0 && verticalSpeed < -3.0 && altitudeValue > 1.0;
        Bundle extrasBundle = new Bundle(1);
        extrasBundle.putBoolean(EXTRA_IS_GROUND_COLLISION_IMMINENT, isCollisionImminent);
        this.notifyAttributeUpdated(ACTION_GROUND_COLLISION_IMMINENT, extrasBundle);
    }

    private void handleRemoteException(RemoteException e) {
        IDroneApi droneApi = this.droneApiRef.get();
        if (droneApi != null && !droneApi.asBinder().pingBinder()) {
            String errorMsg = e.getMessage();
            Log.e((String)TAG, (String)errorMsg, (Throwable)e);
            this.notifyDroneServiceInterrupted(errorMsg);
        }
    }

    public double getSpeedParameter() {
        Parameter speedParam;
        Parameters params = (Parameters)this.getAttribute("com.o3dr.services.android.lib.attribute.PARAMETERS");
        if (params != null && (speedParam = params.getParameter("WPNAV_SPEED")) != null) {
            return speedParam.getValue();
        }
        return 0.0;
    }

    public void post(Runnable action) {
        if (this.handler == null || action == null) {
            return;
        }
        this.handler.post(action);
    }

    public void resetFlightTimer() {
        this.elapsedFlightTime = 0L;
        this.startTime = SystemClock.elapsedRealtime();
    }

    private void stopTimer() {
        this.elapsedFlightTime += SystemClock.elapsedRealtime() - this.startTime;
        this.startTime = SystemClock.elapsedRealtime();
    }

    public long getFlightTime() {
        State droneState = (State)this.getAttribute("com.o3dr.services.android.lib.attribute.STATE");
        if (droneState != null && droneState.isFlying()) {
            this.elapsedFlightTime += SystemClock.elapsedRealtime() - this.startTime;
            this.startTime = SystemClock.elapsedRealtime();
        }
        return this.elapsedFlightTime / 1000L;
    }

    public <T extends Parcelable> T getAttribute(String type) {
        IDroneApi droneApi = this.droneApiRef.get();
        if (!this.isStarted(droneApi) || type == null) {
            return this.getAttributeDefaultValue(type);
        }
        Parcelable attribute = null;
        Bundle carrier = null;
        try {
            carrier = droneApi.getAttribute(type);
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        if (carrier != null) {
            try {
                carrier.setClassLoader(this.contextClassLoader);
                attribute = carrier.getParcelable(type);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
        return (T)(attribute == null ? (Parcelable)this.getAttributeDefaultValue(type) : attribute);
    }

    public <T extends Parcelable> void getAttributeAsync(final String attributeType, final OnAttributeRetrievedCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback must be non-null.");
        }
        IDroneApi droneApi = this.droneApiRef.get();
        if (!this.isStarted(droneApi)) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onRetrievalFailed();
                }
            });
            return;
        }
        this.asyncScheduler.execute(new Runnable(){

            @Override
            public void run() {
                Object attribute = Drone.this.getAttribute(attributeType);
                Drone.this.handler.post(new Runnable((Parcelable)attribute){
                    final /* synthetic */ Parcelable val$attribute;
                    {
                        this.val$attribute = parcelable;
                    }

                    @Override
                    public void run() {
                        if (this.val$attribute == null) {
                            callback.onRetrievalFailed();
                        } else {
                            callback.onRetrievalSucceed(this.val$attribute);
                        }
                    }
                });
            }
        });
    }

    private <T extends Parcelable> T getAttributeDefaultValue(String attributeType) {
        if (attributeType == null) {
            return null;
        }
        switch (attributeType) {
            case "com.o3dr.services.android.lib.attribute.ALTITUDE": {
                return (T)new Altitude();
            }
            case "com.o3dr.services.android.lib.attribute.GPS": {
                return (T)new Gps();
            }
            case "com.o3dr.services.android.lib.attribute.STATE": {
                return (T)new State();
            }
            case "com.o3dr.services.android.lib.attribute.PARAMETERS": {
                return (T)new Parameters();
            }
            case "com.o3dr.services.android.lib.attribute.SPEED": {
                return (T)new Speed();
            }
            case "com.o3dr.services.android.lib.attribute.ATTITUDE": {
                return (T)new Attitude();
            }
            case "com.o3dr.services.android.lib.attribute.HOME": {
                return (T)new Home();
            }
            case "com.o3dr.services.android.lib.attribute.BATTERY": {
                return (T)new Battery();
            }
            case "com.o3dr.services.android.lib.attribute.MISSION": {
                return (T)new Mission();
            }
            case "com.o3dr.services.android.lib.attribute.SIGNAL": {
                return (T)new Signal();
            }
            case "com.o3dr.services.android.lib.attribute.GUIDED_STATE": {
                return (T)new GuidedState();
            }
            case "com.o3dr.services.android.lib.attribute.TYPE": {
                return (T)new Type();
            }
            case "com.o3dr.services.android.lib.attribute.FOLLOW_STATE": {
                return (T)new FollowState();
            }
            case "com.o3dr.services.android.lib.attribute.MAGNETOMETER_CALIBRATION_STATUS": {
                return (T)new MagnetometerCalibrationStatus();
            }
            case "com.o3dr.services.android.lib.attribute.RETURN_TO_ME_STATE": {
                return (T)new ReturnToMeState();
            }
        }
        return null;
    }

    public void connect(ConnectionParameter connParams) {
        this.connect(connParams, null);
    }

    public void connect(ConnectionParameter connParams, LinkListener linkListener) {
        VehicleApi.getApi(this).connect(connParams);
        this.connectionParameter = connParams;
        this.linkListener = linkListener;
    }

    public void disconnect() {
        VehicleApi.getApi(this).disconnect();
        this.connectionParameter = null;
        this.linkListener = null;
    }

    private static AbstractCommandListener wrapListener(final Handler handler, final AbstractCommandListener listener) {
        AbstractCommandListener wrapperListener = listener;
        if (handler != null && listener != null) {
            wrapperListener = new AbstractCommandListener(){

                @Override
                public void onSuccess() {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onSuccess();
                        }
                    });
                }

                @Override
                public void onError(final int executionError) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onError(executionError);
                        }
                    });
                }

                @Override
                public void onTimeout() {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onTimeout();
                        }
                    });
                }
            };
        }
        return wrapperListener;
    }

    public boolean performAction(Action action) {
        return this.performActionOnDroneThread(action, null);
    }

    public boolean performActionOnDroneThread(Action action, AbstractCommandListener listener) {
        return this.performActionOnHandler(action, this.handler, listener);
    }

    public boolean performActionOnHandler(Action action, Handler handler, AbstractCommandListener listener) {
        IDroneApi droneApi = this.droneApiRef.get();
        if (this.isStarted(droneApi)) {
            try {
                droneApi.executeAction(action, Drone.wrapListener(handler, listener));
                return true;
            }
            catch (RemoteException e) {
                this.handleRemoteException(e);
            }
        }
        return false;
    }

    public boolean performAsyncAction(Action action) {
        return this.performAsyncActionOnDroneThread(action, null);
    }

    public boolean performAsyncActionOnDroneThread(Action action, AbstractCommandListener listener) {
        return this.performAsyncActionOnHandler(action, this.handler, listener);
    }

    public boolean performAsyncActionOnHandler(Action action, Handler handler, AbstractCommandListener listener) {
        IDroneApi droneApi = this.droneApiRef.get();
        if (this.isStarted(droneApi)) {
            try {
                droneApi.executeAsyncAction(action, Drone.wrapListener(handler, listener));
                return true;
            }
            catch (RemoteException e) {
                this.handleRemoteException(e);
            }
        }
        return false;
    }

    private boolean isStarted(IDroneApi droneApi) {
        return droneApi != null && droneApi.asBinder().pingBinder();
    }

    public boolean isStarted() {
        return this.isStarted(this.droneApiRef.get());
    }

    public boolean isConnected() {
        IDroneApi droneApi = this.droneApiRef.get();
        State droneState = (State)this.getAttribute("com.o3dr.services.android.lib.attribute.STATE");
        return this.isStarted(droneApi) && droneState.isConnected();
    }

    public ConnectionParameter getConnectionParameter() {
        return this.connectionParameter;
    }

    public <T extends MissionItem> void buildMissionItemsAsync(final MissionItem.ComplexItem<T>[] missionItems, final OnMissionItemsBuiltCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback must be non-null.");
        }
        if (missionItems == null || missionItems.length == 0) {
            return;
        }
        this.asyncScheduler.execute(new Runnable(){

            @Override
            public void run() {
                for (MissionItem.ComplexItem missionItem : missionItems) {
                    MissionApi.getApi(Drone.this).buildMissionItem(missionItem);
                }
                Drone.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onMissionItemsBuilt(missionItems);
                    }
                });
            }
        });
    }

    public void registerDroneListener(DroneListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.droneListeners.contains(listener)) {
            this.droneListeners.add(listener);
        }
    }

    private void addAttributesObserver(IDroneApi droneApi, IObserver observer) {
        if (this.isStarted(droneApi)) {
            try {
                droneApi.addAttributesObserver(observer);
            }
            catch (RemoteException e) {
                this.handleRemoteException(e);
            }
        }
    }

    public void addMavlinkObserver(MavlinkObserver observer) {
        IDroneApi droneApi = this.droneApiRef.get();
        if (this.isStarted(droneApi)) {
            try {
                droneApi.addMavlinkObserver(observer);
            }
            catch (RemoteException e) {
                this.handleRemoteException(e);
            }
        }
    }

    public void removeMavlinkObserver(MavlinkObserver observer) {
        IDroneApi droneApi = this.droneApiRef.get();
        if (this.isStarted(droneApi)) {
            try {
                droneApi.removeMavlinkObserver(observer);
            }
            catch (RemoteException e) {
                this.handleRemoteException(e);
            }
        }
    }

    public void unregisterDroneListener(DroneListener listener) {
        if (listener == null) {
            return;
        }
        this.droneListeners.remove(listener);
    }

    private void removeAttributesObserver(IDroneApi droneApi, IObserver observer) {
        if (this.isStarted(droneApi)) {
            try {
                droneApi.removeAttributesObserver(observer);
            }
            catch (RemoteException e) {
                this.handleRemoteException(e);
            }
        }
    }

    public void changeVehicleMode(VehicleMode newMode) {
        VehicleApi.getApi(this).setVehicleMode(newMode);
    }

    public void refreshParameters() {
        VehicleApi.getApi(this).refreshParameters();
    }

    public void writeParameters(Parameters parameters) {
        VehicleApi.getApi(this).writeParameters(parameters);
    }

    public void setMission(Mission mission, boolean pushToDrone) {
        MissionApi.getApi(this).setMission(mission, pushToDrone);
    }

    public void generateDronie() {
        MissionApi.getApi(this).generateDronie();
    }

    public void arm(boolean arm) {
        VehicleApi.getApi(this).arm(arm);
    }

    public void startIMUCalibration() {
        CalibrationApi.getApi(this).startIMUCalibration();
    }

    public void sendIMUCalibrationAck(int step) {
        CalibrationApi.getApi(this).sendIMUAck(step);
    }

    public void doGuidedTakeoff(double altitude) {
        ControlApi.getApi(this).takeoff(altitude, null);
    }

    public void pauseAtCurrentLocation() {
        ControlApi.getApi(this).pauseAtCurrentLocation(null);
    }

    public void sendGuidedPoint(LatLong point, boolean force) {
        ControlApi.getApi(this).goTo(point, force, null);
    }

    public void sendMavlinkMessage(MavlinkMessageWrapper messageWrapper) {
        ExperimentalApi.getApi(this).sendMavlinkMessage(messageWrapper);
    }

    public void setGuidedAltitude(double altitude) {
        ControlApi.getApi(this).climbTo(altitude);
    }

    public void enableFollowMe(FollowType followType) {
        FollowApi.getApi(this).enableFollowMe(followType);
    }

    public void disableFollowMe() {
        FollowApi.getApi(this).disableFollowMe();
    }

    public void triggerCamera() {
        ExperimentalApi.getApi(this).triggerCamera();
    }

    public void loadWaypoints() {
        MissionApi.getApi(this).loadWaypoints();
    }

    public Handler getHandler() {
        return this.handler;
    }

    void notifyDroneConnectionFailed(final ConnectionResult result) {
        if (this.droneListeners.isEmpty()) {
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (DroneListener listener : Drone.this.droneListeners) {
                    listener.onDroneConnectionFailed(result);
                }
            }
        });
    }

    void notifyAttributeUpdated(String attributeEvent, Bundle extras) {
        if (extras != null) {
            extras.setClassLoader(this.contextClassLoader);
        }
        switch (attributeEvent) {
            case "com.o3dr.services.android.lib.attribute.event.STATE_UPDATED": {
                this.getAttributeAsync("com.o3dr.services.android.lib.attribute.STATE", new OnAttributeRetrievedCallback<State>(){

                    @Override
                    public void onRetrievalSucceed(State state) {
                        if (state.isFlying()) {
                            Drone.this.resetFlightTimer();
                        } else {
                            Drone.this.stopTimer();
                        }
                    }

                    @Override
                    public void onRetrievalFailed() {
                        Drone.this.stopTimer();
                    }
                });
                break;
            }
            case "com.o3dr.services.android.lib.attribute.event.SPEED_UPDATED": {
                this.checkForGroundCollision();
                break;
            }
            case "com.o3dr.services.android.lib.drone.companion.solo.event.SOLO_TX_POWER_COMPLIANCE_COUNTRY_UPDATED": {
                String compliantCountry = extras.getString("com.o3dr.services.android.lib.drone.companion.solo.event.extra.EXTRA_SOLO_TX_POWER_COMPLIANT_COUNTRY");
                Bundle eventInfo = new Bundle(1);
                boolean isEUCompliant = !TxPowerComplianceCountries.getDefaultCountry().name().equals(compliantCountry);
                eventInfo.putBoolean("com.o3dr.services.android.lib.drone.companion.solo.event.extra.EXTRA_SOLO_EU_TX_POWER_COMPLIANT", isEUCompliant);
                this.sendDroneEventToListeners("com.o3dr.services.android.lib.drone.companion.solo.event.SOLO_EU_TX_POWER_COMPLIANCE_UPDATED", eventInfo);
                break;
            }
            case "com.o3dr.services.android.lib.gcs.link.event.LINK_STATE_UPDATED": {
                this.sendLinkEventToListener(extras);
                return;
            }
        }
        this.sendDroneEventToListeners(attributeEvent, extras);
    }

    private void sendDroneEventToListeners(final String attributeEvent, final Bundle extras) {
        if (this.droneListeners.isEmpty()) {
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (DroneListener listener : Drone.this.droneListeners) {
                    try {
                        listener.onDroneEvent(attributeEvent, extras);
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
    }

    private void sendLinkEventToListener(Bundle extras) {
        LinkConnectionStatus status;
        if (this.linkListener == null) {
            return;
        }
        if (extras != null && (status = (LinkConnectionStatus)extras.getParcelable("com.o3dr.services.android.lib.gcs.link.event.extra.CONNECTION_STATUS")) != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Drone.this.linkListener.onLinkStateUpdated(status);
                }
            });
        }
    }

    void notifyDroneServiceInterrupted(final String errorMsg) {
        if (this.droneListeners.isEmpty()) {
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (DroneListener listener : Drone.this.droneListeners) {
                    listener.onDroneServiceInterrupted(errorMsg);
                }
            }
        });
    }

    public static interface OnMissionItemsBuiltCallback<T extends MissionItem> {
        public void onMissionItemsBuilt(MissionItem.ComplexItem<T>[] var1);
    }

    public static class AttributeRetrievedListener<T extends Parcelable>
    implements OnAttributeRetrievedCallback<T> {
        @Override
        public void onRetrievalSucceed(T attribute) {
        }

        @Override
        public void onRetrievalFailed() {
        }
    }

    public static interface OnAttributeRetrievedCallback<T extends Parcelable> {
        public void onRetrievalSucceed(T var1);

        public void onRetrievalFailed();
    }
}

